<?php if(request('tab') == 'loan'): ?>
<div
    class="<?php echo \Illuminate\Support\Arr::toCssClasses([
        'tab-pane fade',
        'show active' => request('tab') == 'loan'
    ]); ?>"
    id="pills-loan"
    role="tabpanel"
    aria-labelledby="pills-loan-tab"
>
    <div class="row">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
            <div class="site-card">
                <div class="site-card-header">
                    <h4 class="title"><?php echo e(__('Loan')); ?></h4>
                </div>
                <div class="site-card-body table-responsive">
                    <div class="site-table">
                        <div class="table-filter">
                            <form action="" method="get">
                                <input type="hidden" name="tab" value="loan">
                                <div class="filter d-flex">
                                    <div class="search">
                                        <label for=""><?php echo e(__('Search:')); ?></label>
                                        <input type="text" name="query" value="<?php echo e(request('query')); ?>"/>
                                    </div>
                                    <button class="apply-btn" type="submit"><i data-lucide="search"></i><?php echo e(__('Search')); ?></button>
                                </div>
                            </form>
                        </div>
                        <table class="table">
                            <thead>
                            <tr>
                                <?php echo $__env->make('backend.filter.th',['label' => 'Date','field' => 'created_at'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php echo $__env->make('backend.filter.th',['label' => 'Loan','field' => 'loan'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php echo $__env->make('backend.filter.th',['label' => 'Loan ID','field' => 'loan_no'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php echo $__env->make('backend.filter.th',['label' => 'Amount','field' => 'amount'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <th><?php echo e(__('Installment Amount')); ?></th>
                                <th><?php echo e(__('Next Payment')); ?></th>
                                <th><?php echo e(__('Installment')); ?></th>
                                <th><?php echo e(__('Paid')); ?></th>
                                <?php echo $__env->make('backend.filter.th',['label' => 'Status','field' => 'status'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $loans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($loan->created_at->format('d M Y h:i A')); ?></td>
                                    <td><?php echo e($loan->plan->name); ?></td>
                                    <td><?php echo e($loan->loan_no); ?></td>
                                    <td>
                                        <?php echo e($currencySymbol.$loan->amount); ?>

                                    </td>
                                    <td><?php echo e($currencySymbol.($loan->amount / 100 ) * $loan->plan->per_installment); ?></td>
                                    <td>
                                        <?php if($loan->status == App\Enums\LoanStatus::Reviewing): ?>
                                            -
                                        <?php else: ?>
                                            <?php echo e(nextInstallment($loan->id, \App\Models\LoanTransaction::class, 'loan_id')); ?>

                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php echo e($loan->plan->total_installment); ?>

                                    </td>
                                    <td>
                                        <?php echo e($currencySymbol.$loan->transactions->sum('amount')); ?>

                                    </td>

                                    <td>
                                        <?php if($loan->status->value == 'running'): ?>
                                            <div class="type site-badge primary"><?php echo e(ucfirst($loan->status->value)); ?></div>
                                        <?php elseif($loan->status->value == 'rejected' || $loan->status->value == 'due'): ?>
                                            <div class="type site-badge danger"><?php echo e(ucfirst($loan->status->value)); ?></div>
                                        <?php elseif($loan->status->value == 'completed' ): ?>
                                            <div class="type site-badge success"><?php echo e(ucfirst($loan->status->value)); ?></div>
                                        <?php elseif($loan->status->value == 'reviewing'): ?>
                                            <div class="type site-badge pending"><?php echo e(ucfirst($loan->status->value)); ?></div>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <td colspan="7" class="text-center"><?php echo e(__('No Data Found')); ?>!</td>
                                <?php endif; ?>
                            </tbody>
                        </table>
                        <?php echo e($loans->links()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>
<?php /**PATH /home/oyxmpnpf/paysmart.azonetech.com.ng/resources/views/backend/user/include/__loan.blade.php ENDPATH**/ ?>