<?php
    $landingContent =\App\Models\LandingContent::where('type','whychooseus')->where('locale',app()->getLocale())->get();
?>

<!-- Why Choose area start -->
<section class="why-choose-area position-relative z-index-11 fix section-space"
    data-background="<?php echo e(asset('/front/images/bg/choose-bg.png')); ?>">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xxl-6 col-xl-6 col-lg-6">
                <div class="section-title-wrapper section-title-space text-center">
                    <span data-aos="fade-up" data-aos-duration="1000" class="section-subtitle bg-lightest"><?php echo e($data['title_small']); ?></span>
                    <h2 data-aos="fade-up" data-aos-duration="1500" class="section-title text-white"><?php echo e($data['title_big']); ?></h2>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-xxl-6 col-xl-6">
                <div class="why-choose-wrapper">
                    <?php $__currentLoopData = $landingContent; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $content): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div data-aos="fade-up" data-aos-duration="1500" class="why-choose-timeline">
                        <div class="timeline-icon">
                            <span><i class="<?php echo e($content->icon); ?>"></i></span>
                        </div>
                        <div class="why-choose-content">
                            <div class="content">
                                <h4 class="title"><?php echo e($content->title); ?></h4>
                                <p class="description">
                                    <?php echo e($content->description); ?>

                                </p>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <div class="col-xxl-6 col-xl-6">
                <div class="why-choose-thumb">
                    <?php if(content_exists($data['right_img'])): ?>
                    <img data-aos="fade-right" data-aos-duration="1500" src="<?php echo e(asset($data['right_img'])); ?>" alt="thumb not found">
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <div class="why-choose-shapes">
        <div class="shape-one shortUPDown">
            <img src="<?php echo e(asset('/front/images/shapes/triangle-shape.png')); ?>" alt="triangle shape not found">
        </div>
        <div class="round"></div>
    </div>
</section>
<!-- Why Choose area end -->
<?php /**PATH /home/oyxmpnpf/paysmart.azonetech.com.ng/app/Providers/../../resources/views/frontend/default/home/include/__whychooseus.blade.php ENDPATH**/ ?>