
<?php if(setting('multiple_currency', 'permission')): ?>
    <?php
        $currencies = \App\Models\Currency::get();
    ?>

    <div class="col-xl-6 col-lg-12 col-md-12 col-12">
        <div class="site-card">
            <div class="site-card-header">
                <h3 class="title"><?php echo e($fields['title']); ?></h3>
            </div>
            <div class="col-xl-3 p-2">
                <a href="javascript:void(0)" id="generate"
                class="site-btn-xs primary-btn mb-3"><?php echo e(__('Add Currency')); ?></a>
            </div>
            <form action="<?php echo e(route('admin.currency.update')); ?>" method="post">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="addOptions p-3" id="currency_elements">
                    <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div>
                            <div class="option-remove-row row">
                                <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
                                    <div class="site-input-groups">
                                        <input name="field_options[<?php echo e($key); ?>][name]" class="box-input" type="text" value="<?php echo e($currency->name); ?>" required placeholder="<?php echo e(__('Currency Name')); ?>">
                                        <input name="field_options[<?php echo e($key); ?>][current_name]" class="box-input" type="hidden" value="<?php echo e($currency->name); ?>">
                                    </div>
                                </div>
                                <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
                                    <div class="site-input-groups">
                                        <input name="field_options[<?php echo e($key); ?>][code]" class="box-input" type="text" value="<?php echo e($currency->code); ?>" required placeholder="<?php echo e(__('Currency Code')); ?>">
                                        <input name="field_options[<?php echo e($key); ?>][current_code]" class="box-input" type="hidden" value="<?php echo e($currency->code); ?>">
                                    </div>
                                </div>
                                <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-12">
                                    <div class="site-input-groups">
                                        <input name="field_options[<?php echo e($key); ?>][symbol]" class="box-input" type="text" value="<?php echo e($currency->symbol); ?>" required placeholder="<?php echo e(__('Currency Symbol')); ?>">
                                        <input name="field_options[<?php echo e($key); ?>][current_symbol]" class="box-input" type="hidden" value="<?php echo e($currency->symbol); ?>">
                                    </div>
                                </div>

                                <div class="col-xl-1 col-lg-6 col-md-6 col-sm-6 col-12">
                                    <button class="delete-option-row delete_desc" type="button" data-id="<?php echo e($currency->id); ?>">
                                    <i class="fas fa-times"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <div class="col-xl-12">
                    <button type="submit" class="site-btn primary-btn w-100">
                        <?php echo e(__('Save Changes')); ?>

                    </button>
                </div>
            </form>
        </div>
    </div>

    <?php $__env->startPush('single-script'); ?>
        <script>
            var i = '<?php echo e($currencies->count()); ?>' - 1;

            $("#generate").on('click', function () {
                ++i;
                var form = `<div>
                    <div class="option-remove-row row">
                        <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
                            <div class="site-input-groups">
                            <input name="field_options[` + i + `][name]" class="box-input" type="text" value="" required placeholder="<?php echo e(__('Currency Name')); ?>" required>
                            </div>
                        </div>
                        <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
                            <div class="site-input-groups">
                            <input name="field_options[` + i + `][code]" class="box-input" type="text" value="" required placeholder="<?php echo e(__('Currency Code')); ?>">
                            </div>
                        </div>
                        <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-12">
                            <div class="site-input-groups">
                            <input name="field_options[` + i + `][symbol]" class="box-input" type="text" value="" required placeholder="<?php echo e(__('Currency Symbol')); ?>">
                            </div>
                        </div>

                        <div class="col-xl-1 col-lg-6 col-md-6 col-sm-6 col-12">
                            <button class="delete-option-row delete_desc" type="button">
                            <i class="fas fa-times"></i>
                            </button>
                        </div>
                    </div>
                    </div>`;
                $('.addOptions').append(form)
            });

            $(document).on('click', '.delete_desc', function (e) {
                var value = $(this).attr('data-id');

                if (value && value != 'undefined') {
                    $("#currency_elements").append('<input type="hidden" name="delete_currencies[]" value="'+value+'">');
                }

                $(this).closest('.option-remove-row').parent().remove();
            });
        </script>
    <?php $__env->stopPush(); ?>
<?php endif; ?>

<?php /**PATH /home/oyxmpnpf/paysmart.azonetech.com.ng/resources/views/backend/setting/site_setting/include/__currency.blade.php ENDPATH**/ ?>