<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('total-users')): ?>
<div class="col-xl-3 col-lg-4 col-md-6 col-sm-6">
    <div class="data-card">
        <div class="icon">
            <i data-lucide="users"></i>
        </div>
        <div class="content">
            <h4 class="count"><?php echo e($data['register_user']); ?></h4>
            <p><?php echo e(__('Total Users')); ?></p>
        </div>
        <a class="link" href="<?php echo e(route('admin.user.index')); ?>"><i data-lucide="external-link"></i></a>
    </div>
</div>
<?php endif; ?>
<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('active-users')): ?>
<div class="col-xl-3 col-lg-4 col-md-6 col-sm-6">
    <div class="data-card">
        <div class="icon">
            <i data-lucide="user-check"></i>
        </div>
        <div class="content">
            <h4 class="count"><?php echo e($data['active_user']); ?></h4>
            <p><?php echo e(__('Active Users')); ?></p>
        </div>
        <a class="link" href="<?php echo e(route('admin.user.active')); ?>"><i data-lucide="external-link"></i></a>
    </div>
</div>
<?php endif; ?>
<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('disabled-users')): ?>
<div class="col-xl-3 col-lg-4 col-md-6 col-sm-6">
    <div class="data-card">
        <div class="icon">
            <i data-lucide="user-round-x"></i>
        </div>
        <div class="content">
            <h4 class="count"><?php echo e($data['disabled_user']); ?></h4>
            <p><?php echo e(__('Disabled Users')); ?></p>
        </div>
        <a class="link" href="<?php echo e(route('admin.user.disabled')); ?>"><i data-lucide="external-link"></i></a>
    </div>
</div>
<?php endif; ?>
<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('total-staff')): ?>
<div class="col-xl-3 col-lg-4 col-md-6 col-sm-6">
    <div class="data-card">
        <div class="icon">
            <i data-lucide="user-cog"></i>
        </div>
        <div class="content">
            <h4 class="count"><?php echo e($data['total_staff']); ?></h4>
            <p><?php echo e(__('Total Staff')); ?></p>
        </div>
        <a class="link" href="<?php echo e(route('admin.staff.index')); ?>"><i data-lucide="external-link"></i></a>
    </div>
</div>
<?php endif; ?>
<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('total-deposits')): ?>
<div class="col-xl-3 col-lg-4 col-md-6 col-sm-6">
    <div class="data-card">
        <div class="icon">
            <i data-lucide="wallet"></i>
        </div>
        <div class="content">
            <h4><?php echo e($currencySymbol); ?><span class="count"><?php echo e($data['total_deposit']); ?></span></h4>
            <p><?php echo e(__('Total Deposits')); ?></p>
        </div>
        <a class="link" href="<?php echo e(route('admin.deposit.history')); ?>"><i data-lucide="external-link"></i></a>
    </div>
</div>
<?php endif; ?>
<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('total-withdraw')): ?>
<div class="col-xl-3 col-lg-4 col-md-6 col-sm-6">
    <div class="data-card">
        <div class="icon">
            <i data-lucide="landmark"></i>
        </div>
        <div class="content">
            <h4><?php echo e($currencySymbol); ?><span class="count"><?php echo e($data['total_withdraw']); ?></span></h4>
            <p><?php echo e(__('Total Withdraw')); ?></p>
        </div>
        <a class="link" href="<?php echo e(route('admin.withdraw.history')); ?>"><i data-lucide="external-link"></i></a>
    </div>
</div>
<?php endif; ?>
<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('total-referral')): ?>
<div class="col-xl-3 col-lg-4 col-md-6 col-sm-6">
    <div class="data-card">
        <div class="icon">
            <i data-lucide="link"></i>
        </div>
        <div class="content">
            <h4 class="count"><?php echo e($data['total_referral']); ?></h4>
            <p><?php echo e(__('Total Referral')); ?></p>
        </div>
    </div>
</div>
<?php endif; ?>
<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('total-fund-transfer')): ?>
<div class="col-xl-3 col-lg-4 col-md-6 col-sm-6">
    <div class="data-card">
        <div class="icon">
            <i data-lucide="send"></i>
        </div>
        <div class="content">
            <h4><?php echo e($currencySymbol); ?><span class="count"><?php echo e($data['total_send']); ?></span></h4>
            <p><?php echo e(__('Total Fund Transfer')); ?></p>
        </div>
    </div>
</div>
<?php endif; ?>
<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('total-dps')): ?>
<div class="col-xl-3 col-lg-4 col-md-6 col-sm-6">
    <div class="data-card">
        <div class="icon">
            <i data-lucide="archive"></i>
        </div>
        <div class="content">
            <h4><?php echo e($currencySymbol); ?><span class="count"><?php echo e($data['total_dps']); ?></span> </h4>
            <p><?php echo e(__('Total DPS')); ?></p>
        </div>
    </div>
</div>
<?php endif; ?>
<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('total-fdr')): ?>
<div class="col-xl-3 col-lg-4 col-md-6 col-sm-6">
    <div class="data-card">
        <div class="icon">
            <i data-lucide="book"></i>
        </div>
        <div class="content">
            <h4><?php echo e($currencySymbol); ?><span class="count"><?php echo e($data['total_fdr']); ?></span> </h4>
            <p><?php echo e(__('Total FDR')); ?></p>
        </div>
    </div>
</div>
<?php endif; ?>
<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('total-loan')): ?>
<div class="col-xl-3 col-lg-4 col-md-6 col-sm-6">
    <div class="data-card">
        <div class="icon">
            <i data-lucide="alert-triangle"></i>
        </div>
        <div class="content">
            <h4><?php echo e($currencySymbol); ?><span class="count"><?php echo e($data['total_loan']); ?></span> </h4>
            <p><?php echo e(__('Total Loan')); ?></p>
        </div>
    </div>
</div>
<?php endif; ?>
<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('total-pay-bill')): ?>
<div class="col-xl-3 col-lg-4 col-md-6 col-sm-6">
    <div class="data-card">
        <div class="icon">
            <i data-lucide="credit-card"></i>
        </div>
        <div class="content">
            <h4><?php echo e($currencySymbol); ?><span class="count"><?php echo e($data['total_bill']); ?></span> </h4>
            <p><?php echo e(__('Total Pay Bill')); ?></p>
        </div>
    </div>
</div>
<?php endif; ?>
<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('total-reward-points')): ?>
<div class="col-xl-3 col-lg-4 col-md-6 col-sm-6">
    <div class="data-card">
        <div class="icon">
            <i data-lucide="gift"></i>
        </div>
        <div class="content">
            <h4 class="count"><?php echo e($data['points']); ?></h4>
            <p><?php echo e(__('Total Reward Points')); ?></p>
        </div>
    </div>
</div>
<?php endif; ?>
<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('deposit-bonus')): ?>
<div class="col-xl-3 col-lg-4 col-md-6 col-sm-6">
    <div class="data-card">
        <div class="icon">
            <i data-lucide="package-plus"></i>
        </div>
        <div class="content">
            <h4><?php echo e($currencySymbol); ?><span class="count"><?php echo e($data['deposit_bonus']); ?></span></h4>
            <p><?php echo e(__('Deposit Bonus')); ?></p>
        </div>
    </div>
</div>
<?php endif; ?>
<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('total-automatic-gateway')): ?>
<div class="col-xl-3 col-lg-4 col-md-6 col-sm-6">
    <div class="data-card">
        <div class="icon">
            <i data-lucide="webhook"></i>
        </div>
        <div class="content">
            <h4 class="count"><?php echo e($data['total_gateway']); ?></h4>
            <p><?php echo e(__('Total Automatic Gateways')); ?></p>
        </div>
        <a class="link" href="<?php echo e(route('admin.gateway.automatic')); ?>"><i data-lucide="external-link"></i></a>
    </div>
</div>
<?php endif; ?>
<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('total-ticket')): ?>
<div class="col-xl-3 col-lg-4 col-md-6 col-sm-6">
    <div class="data-card">
        <div class="icon">
            <i data-lucide="help-circle"></i>
        </div>
        <div class="content">
            <h4 class="count"><?php echo e($data['total_ticket']); ?></h4>
            <p><?php echo e(__('Total Ticket')); ?></p>
        </div>
        <a class="link" href="<?php echo e(route('admin.ticket.index')); ?>"><i data-lucide="external-link"></i></a>
    </div>
</div>
<?php endif; ?>
<?php /**PATH /home/oyxmpnpf/paysmart.azonetech.com.ng/resources/views/backend/include/__data_card.blade.php ENDPATH**/ ?>