

<?php $__env->startSection('title'); ?>
    <?php echo e(__('Register')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <!-- Register Section -->
    <div class="half-authpage">
        <div class="authOne">
            <div class="auth-contents">
                <?php
                    $height = setting('site_logo_height','global') == 'auto' ? 'auto' : setting('site_logo_height','global').'px';
                    $width = setting('site_logo_width','global') == 'auto' ? 'auto' : setting('site_logo_width','global').'px';
                ?>
                <div class="logo">
                    <a href="<?php echo e(route('home')); ?>"><img src="<?php echo e(asset(setting('site_logo','global'))); ?>" style="height:<?php echo e($height); ?>;width:<?php echo e($width); ?>;max-width:none" alt=""></a>
                    <div class="no-user-header">
                        <?php if(setting('language_switcher')): ?>
                            <div class="language-switcher">
                                <select class="langu-swit small" name="language" id=""
                                        onchange="window.location.href=this.options[this.selectedIndex].value;">
                                    <?php $__currentLoopData = \App\Models\Language::where('status',true)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option
                                            value="<?php echo e(route('language-update',['name'=> $lang->locale])); ?>" <?php if( app()->getLocale() == $lang->locale ): echo 'selected'; endif; ?>><?php echo e($lang->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        <?php endif; ?>
                        <div class="color-switcher">
                            <img class="light-icon" src="<?php echo e(asset('front/images/icons/sun.png')); ?>" alt="">
                            <img class="dark-icon" src="<?php echo e(asset('front/images/icons/moon.png')); ?>" alt="">
                        </div>
                    </div>
                </div>
                <div class="contents">
                    <div class="content">
                        <h3><?php echo e(data_get($data,'title',__('Create an account'))); ?></h3>
                        <?php if($errors->any()): ?>
                            <div class="error-message">
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <p><?php echo e($error); ?></p>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        <?php endif; ?>

                        <form method="POST" action="<?php echo e(route('register')); ?>">
                            <?php echo csrf_field(); ?>

                            <div class="inputs">
                                <label for=""><?php echo e(__('Email')); ?><span class="required">*</span></label>
                                <input type="email" name="email" value="<?php echo e(old('email')); ?>" class="box-input" required>
                            </div>

                            <?php if(getPageSetting('country_show')): ?>
                            <div class="inputs">
                                <label for=""><?php echo e(__('Country')); ?> <?php if(getPageSetting('country_validation')): ?><span class="required">*</span> <?php endif; ?></label>
                                <select name="country" class="box-input select2-basic-active" id="countrySelect">
                                    <?php $__currentLoopData = getCountries(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option data-flag="https://flagcdn.com/48x36/<?php echo e(strtolower(data_get($country,'code'))); ?>.png" <?php if($location->country_code == $country['code']): echo 'selected'; endif; ?> value="<?php echo e($country['name'].':'.$country['dial_code']); ?>" data-code="<?php echo e($country['dial_code']); ?>"><?php echo e($country['name']); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <?php endif; ?>
                            <?php if(getPageSetting('phone_show')): ?>
                                <div class="inputs">
                                    <label for=""><?php echo e(__('Phone')); ?> <?php if(getPageSetting('phone_validation')): ?><span class="required">*</span> <?php endif; ?></label>
                                    <div class="input-group">
                                        <span class="input-group-text" id="dial-code"><?php echo e(getLocation()->dial_code); ?></span>
                                        <input type="text" name="phone" value="<?php echo e(old('phone')); ?>" class="form-control">
                                    </div>
                                </div>
                            <?php endif; ?>
                            <?php if(getPageSetting('referral_code_show')): ?>
                                <div class="inputs">
                                    <label for=""><?php echo e(__('Referral Code')); ?> <?php if(getPageSetting('referral_code_validation')): ?><span class="required">*</span> <?php endif; ?></label>
                                    <input type="text" name="invite" value="<?php echo e(old('invite',$referralCode)); ?>" class="box-input">
                                </div>
                            <?php endif; ?>
                            <div class="inputs">
                                <label for=""><?php echo e(__('Password')); ?><span class="required">*</span></label>
                                <div class="passo">
                                    <input type="password" name="password" class="box-input" id="passo2" required>
                                    <img src="<?php echo e(asset('front/images/icons/eye-off.svg')); ?>" class="passo-hide-show" id="eyeicon2" alt="">
                                </div>
                            </div>

                            <div class="inputs centered">
                                <button type="submit" class="site-btn primary-btn w-100"><i data-lucide="arrow-right"></i><?php echo e(__('1/2 Next Step')); ?></button>
                            </div>
                        </form>
                        <p><?php echo e(__('Already have an account?')); ?> <a href="<?php echo e(route('login')); ?>"><?php echo e(__('Login')); ?></a></p>
                    </div>
                </div>
            </div>
        </div>
        <div class="authOne">
            <div class="auth-banner" style="background: url('<?php echo e(asset($data['right_image'])); ?>') no-repeat;"></div>
        </div>
    </div>
    <!-- Register Section End -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        (function($) {
            'use strict';

            // password hide show
            let eyeicon2 = document.getElementById('eyeicon2')
            let passo2 = document.getElementById('passo2')

            eyeicon2.onclick = function() {
                if(passo2.type == "password") {
                    passo2.type = "text";
                    eyeicon2.src = '<?php echo e(url("assets/front/images/icons/eye.svg")); ?>'
                } else {
                    passo2.type = "password";
                    eyeicon2.src = '<?php echo e(url("assets/front/images/icons/eye-off.svg")); ?>'
                }
            }

            // Select 2 activation
            function formatState(state) {
                if (!state.id) {
                    return state.text;
                }

                var $state = $(
                    '<span><img src="' + $(state.element).data('flag') + '" class="img-icon" /> ' + state.text + '</span>'
                );

                return $state;
            };

            $('.select2-basic-active').select2({
                templateResult: formatState,
                templateSelection: formatState,
            });

            // Country Select
            $('#countrySelect').on('change', function (e) {
                "use strict";
                e.preventDefault();
                var country = $(this).val();
                $('#dial-code').html(country.split(":")[1])
            })

        })(jQuery);
    </script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('frontend::layouts.auth', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/oyxmpnpf/paysmart.azonetech.com.ng/app/Providers/../../resources/views/frontend/default/auth/register.blade.php ENDPATH**/ ?>