<!DOCTYPE html>
<?php
    $isRtl = isRtl(app()->getLocale());
?>
<html lang="<?php echo e(app()->getLocale()); ?>" <?php if($isRtl): ?> dir="rtl" <?php endif; ?>>
<?php echo $__env->make('frontend::include.__head', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<body class="<?php echo \Illuminate\Support\Arr::toCssClasses([
    'dark-theme' => session()->get('site-color-mode',setting('default_mode')) == 'dark',
    'rtl_mode' => $isRtl,
    'body-landing-bg'
]); ?>">
    <!--Notification-->
    <?php echo $__env->make('global._notify', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Pre loader area start -->
    <div class="preloader">
        <div class='loader'>
            <div class='circle'></div>
            <div class='circle'></div>
            <div class='circle'></div>
            <div class='circle'></div>
            <div class='circle'></div>
        </div>
    </div>
    <!-- Pre loader area end -->

    <!-- Offcanvas area start -->
    <div class="fix">
        <div class="offcanvas-area">
            <div class="offcanva-wrapper">
                <div class="offcanvas-content">
                    <div class="offcanvas-top d-flex justify-content-between align-items-center">
                        <div class="offcanvas-logo">
                            <a href="/">
                                <img src="<?php echo e(asset(setting('site_logo','global'))); ?>" alt="logo not found">
                            </a>
                        </div>
                        <div class="offcanvas-close">
                            <button class="offcanvas-close-icon animation--flip">
                                <span class="offcanvas-m-lines">
                                    <span class="offcanvas-m-line line--1"></span><span
                                        class="offcanvas-m-line line--2"></span><span
                                        class="offcanvas-m-line line--3"></span>
                                </span>
                            </button>
                        </div>
                    </div>
                    <div class="mobile-menu fix"></div>
                    <div class="offcanvas-btn mb-3">
                        <?php if(auth()->guard('web')->check()): ?>
                        <a class="gradient-btn" href="<?php echo e(route('user.dashboard')); ?>">
                            <span><i data-lucide="layout-dashboard"></i></span>
                            <?php echo e(__('Dashboard')); ?>

                        </a>
                        <?php else: ?>
                            <a class="gradient-btn" href="<?php echo e(route('login')); ?>">
                                <span><i data-lucide="circle-user-round"></i></span>
                                <?php echo e(__('Log In')); ?>

                            </a>
                            <a class="td-primary-btn" href="<?php echo e(route('register')); ?>">
                                <span><i data-lucide="user-round-plus"></i></span>
                                <?php echo e(__('Sign Up')); ?>

                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="offcanvas-overlay"></div>
    <div class="offcanvas-overlay-white"></div>
    <!-- Offcanvas area start -->
    <?php if(setting('back_to_top','permission')): ?>
    <!-- Backtotop start -->
    <div class="backtotop-wrap cursor-pointer">
        <svg class="backtotop-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
            <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" />
        </svg>
    </div>
    <!-- Backtotop end -->
    <?php endif; ?>

    <?php echo $__env->make('frontend::include.__header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Body main wrapper start -->
    <main class="fix">
        <?php echo $__env->yieldContent('content'); ?>
    </main>
    <!-- Body main wrapper end -->

    <?php echo $__env->make('frontend::include.__footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('frontend::cookie.gdpr_cookie', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('frontend::include.__script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <script src="<?php echo e(asset('front/js/landing.js?v1.0')); ?>"></script>

</body>
</html>


<?php /**PATH /home/oyxmpnpf/paysmart.azonetech.com.ng/app/Providers/../../resources/views/frontend/default/layouts/app.blade.php ENDPATH**/ ?>