<!DOCTYPE html>
<?php
    $isRtl = isRtl(app()->getLocale());
?>
<html lang="<?php echo e(app()->getLocale()); ?>" <?php if($isRtl): ?> dir="rtl" <?php endif; ?>>
<?php echo $__env->make('frontend::include.__head', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<body class="<?php echo \Illuminate\Support\Arr::toCssClasses([
    'dark-theme' => session()->get('site-color-mode',setting('default_mode')) == 'dark',
    'rtl_mode' => $isRtl
]); ?>">

<!--Notification-->
<?php echo $__env->make('global._notify', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- Dashboard Section -->
<main class="main-user-dahboard">
    <?php echo $__env->make('frontend::include.__user_side_nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="page-content">
        <div class="main-content">
            <?php echo $__env->make('frontend::include.__user_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="page-gap">
                <div class="container-fluid">
                    <?php if(auth()->user()->kyc !== \App\Enums\KYCStatus::Verified->value): ?>
                        <?php echo $__env->make('frontend::include.__kyc_warning', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                    <?php echo $__env->yieldContent('content'); ?>
                </div>
            </div>
        </div>
    </div>
</main>
<!-- Dashboard Section End -->

<?php echo $__env->make('frontend::include.__script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>
</html>


<?php /**PATH /home/oyxmpnpf/paysmart.azonetech.com.ng/app/Providers/../../resources/views/frontend/default/layouts/user.blade.php ENDPATH**/ ?>