
<!-- Header area start -->
<header>
    <div id="header-sticky" class="header-area header-transparent">
        <div class="container">
            <div class="mega-menu-wrapper position-relative">
                <div class="header-main">
                    <div class="header-left">
                        <div class="header-logo">
                            <a href="<?php echo e(route('home')); ?>">
                                <?php
                                    $height = setting('site_logo_height','global') == 'auto' ? 'auto' : setting('site_logo_height','global').'px';
                                    $width = setting('site_logo_width','global') == 'auto' ? 'auto' : setting('site_logo_width','global').'px';
                                ?>
                                <img class="logo-white" src="<?php echo e(asset(setting('site_logo','global'))); ?>" style="height:<?php echo e($height); ?>;width:<?php echo e($width); ?>;max-width:none" alt="<?php echo e(setting('site_title','global')); ?>">
                            </a>
                        </div>
                    </div>

                    <div class="header-middle">
                        <div class="mean__menu-wrapper d-none d-lg-block">
                            <div class="main-menu">
                                <nav id="mobile-menu">
                                    <ul>
                                        <?php $__currentLoopData = $navigations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $navigation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($navigation->page_id == null): ?>
                                            <li class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                                'active' => $navigation->url == Request::url()
                                            ]); ?>">
                                                <a href="<?php echo e($navigation->url); ?>"><?php echo e($navigation->tname); ?></a>
                                            </li>
                                            <?php else: ?>
                                            <li class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                                'active' => url($navigation->url) == Request::url()
                                            ]); ?>">
                                                <a href="<?php echo e(url($navigation->url)); ?>"><?php echo e($navigation->tname); ?></a>
                                            </li>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </nav>
                            </div>
                        </div>
                    </div>
                    <div class="header-right">
                        <div class="header-action">
                            <div class="quick-use">
                                <div class="language-switcher">
                                    <?php if(setting('language_switcher')): ?>
                                    <select name="language" class="langu-swit small" onchange="window.location.href=this.options[this.selectedIndex].value;">
                                        <?php $__currentLoopData = \App\Models\Language::where('status',true)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e(route('language-update',['name'=> $lang->locale])); ?>" <?php if(app()->getLocale() == $lang->locale || $lang->is_default): echo 'selected'; endif; ?>><?php echo e($lang->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php endif; ?>
                                </div>
                                <div class="color-switcher">
                                    <img class="light-icon" src="<?php echo e(asset('/front/images/icons/sun.png')); ?>" alt="">
                                    <img class="dark-icon" src="<?php echo e(asset('/front/images/icons/moon.png')); ?>" alt="">
                                </div>
                            </div>

                            <div class="header-btn-wrap d-none d-xl-inline-flex">
                                <?php if(auth()->guard('web')->check()): ?>
                                <a class="gradient-btn" href="<?php echo e(route('user.dashboard')); ?>">
                                    <span><i data-lucide="layout-dashboard"></i></span>
                                    <?php echo e(__('Dashboard')); ?>

                                </a>
                                <?php else: ?>
                                    <a class="td-primary-btn" href="<?php echo e(route('register')); ?>">
                                        <span><i data-lucide="user-round-plus"></i></span>
                                        <?php echo e(__('Sign Up')); ?>

                                    </a>
                                    <a class="gradient-btn" href="<?php echo e(route('login')); ?>">
                                        <span><i data-lucide="circle-user-round"></i></span>
                                        <?php echo e(__('Log In')); ?>

                                    </a>
                                <?php endif; ?>
                            </div>
                            <div class="header-hamburger ml-20 d-xl-none">
                                <div class="sidebar-toggle">
                                    <a class="bar-icon" href="javascript:void(0)">
                                        <span></span>
                                        <span></span>
                                        <span></span>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</header>
<!-- Header area end -->
<?php /**PATH /home/oyxmpnpf/paysmart.azonetech.com.ng/app/Providers/../../resources/views/frontend/default/include/__header.blade.php ENDPATH**/ ?>