
<?php if(request('tab') == 'dps'): ?>
<div
    class="<?php echo \Illuminate\Support\Arr::toCssClasses([
        'tab-pane fade',
        'show active' => request('tab') == 'dps'
    ]); ?>"
    id="pills-dps"
    role="tabpanel"
    aria-labelledby="pills-dps-tab"
>
    <div class="row">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
            <div class="site-card">
                <div class="site-card-header">
                    <h4 class="title"><?php echo e(__('DPS')); ?></h4>
                </div>
                <div class="site-card-body table-responsive">
                    <div class="site-table">
                        <div class="table-filter">
                            <form action="" method="get">
                                <input type="hidden" name="tab" value="dps">
                                <div class="filter d-flex">
                                    <div class="search">
                                        <label for=""><?php echo e(__('Search:')); ?></label>
                                        <input type="text" name="query" value="<?php echo e(request('query')); ?>"/>
                                    </div>
                                    <button class="apply-btn" type="submit"><i data-lucide="search"></i><?php echo e(__('Search')); ?></button>
                                </div>
                            </form>
                        </div>
                        <table class="table">
                            <thead>
                            <tr>
                                <?php echo $__env->make('backend.filter.th',['label' => 'Date','field' => 'created_at'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php echo $__env->make('backend.filter.th',['label' => 'DPS','field' => 'dps'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php echo $__env->make('backend.filter.th',['label' => 'DPS ID','field' => 'dps_id'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php echo $__env->make('backend.filter.th',['label' => 'Rate','field' => 'interest_rate'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php echo $__env->make('backend.filter.th',['label' => 'Amount','field' => 'per_installment'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <th><?php echo e(__('Next Installment')); ?></th>
                                <th><?php echo e(__('Installments')); ?></th>
                                <th><?php echo e(__('Matured Amount')); ?></th>
                                <?php echo $__env->make('backend.filter.th',['label' => 'Status','field' => 'status'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $dpses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dps): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($dps->created_at); ?></td>
                                    <td><?php echo e($dps->plan->name); ?></td>
                                    <td><?php echo e($dps->dps_id); ?></td>
                                    <td><?php echo e($dps->plan->interest_rate); ?>%</td>
                                    <td>
                                        <?php echo e($currencySymbol.$dps->per_installment); ?>

                                    </td>
                                    <td><?php echo e(nextInstallment($dps->id, \App\Models\DpsTransaction::class, 'dps_id')); ?></td>
                                    <td>
                                        <?php echo e($dps->plan->total_installment); ?>

                                    </td>
                                    <td>
                                        <?php echo e($currencySymbol.getTotalMature($dps)); ?>

                                    </td>
                                    <td>
                                        <?php if($dps->status->value == 'running'): ?>
                                            <div class="type site-badge primary"><?php echo e(ucfirst($dps->status->value)); ?></div>
                                        <?php elseif($dps->status->value == 'closed'): ?>
                                            <div class="type site-badge danger"><?php echo e(ucfirst($dps->status->value)); ?></div>
                                        <?php elseif($dps->status->value == 'mature'): ?>
                                            <div class="type site-badge success"><?php echo e(ucfirst($dps->status->value)); ?></div>
                                        <?php elseif($dps->status->value == 'due'): ?>
                                            <div class="type site-badge pending"><?php echo e(ucfirst($dps->status->value)); ?></div>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <td colspan="7" class="text-center"><?php echo e(__('No Data Found')); ?>!</td>
                                <?php endif; ?>
                            </tbody>
                        </table>
                        <?php echo e($dpses->links()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>
<?php /**PATH /home/oyxmpnpf/paysmart.azonetech.com.ng/resources/views/backend/user/include/__dps.blade.php ENDPATH**/ ?>