<?php
    $footerContent = json_decode(\App\Models\LandingPage::where('locale',app()->getLocale())->where('code','footer')->first()?->data,true);
?>

<?php if(!Route::is('home')): ?>
<?php echo $__env->make('frontend::home.include.__cta', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php endif; ?>
<!-- Footer area start -->
<footer>
    <div class="footer-area footer-primary position-relative z-index-1 include-bg"
        data-background="<?php echo e(asset('/')); ?>/front/images/bg/footer-ring.png">
        <div class="container">
            <div class="footer-main">
                <div class="row gy-50">
                    <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-6 col-sm-6">
                        <div class="footer-widget-1-1">
                            <?php
                                $height = setting('site_logo_height','global') == 'auto' ? 'auto' : setting('site_logo_height','global').'px';
                                $width = setting('site_logo_width','global') == 'auto' ? 'auto' : setting('site_logo_width','global').'px';
                            ?>
                            <div class="footer-logo">
                                <a href="<?php echo e(route('home')); ?>">
                                    <img src="<?php echo e(asset(setting('site_logo','global'))); ?>" style="height:<?php echo e($height); ?>;width:<?php echo e($width); ?>;max-width:none" alt="logo not found">
                                </a>
                            </div>
                            <div class="footer-content">
                                <p>
                                    <?php echo e($footerContent['widget_left_description']); ?>

                                </p>
                                <h6 class="title"><?php echo e(__('Subscribe Now')); ?></h6>
                                <form action="<?php echo e(route('subscriber')); ?>" method="post">
                                    <?php echo csrf_field(); ?>
                                    <div class="footer-newsletter-from">
                                        <div class="footer-newsletter-input position-relative">
                                            <input type="text" placeholder="Enter your email" name="email" autocomplete="off">
                                            <button class="footer-round-btn" type="submit"><?php echo e(__('Subscribe')); ?></button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <?php $__currentLoopData = $navigations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $navigation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $columns = $loop->first ? 'col-xxl-3 col-xl-3 col-lg-3' : 'col-xxl-2 col-xl-2 col-lg-2';
                        ?>
                    <div class="<?php echo e($columns); ?> col-md-6 col-sm-6">
                        <div class="footer-widget-1-<?php echo e($loop->iteration+1); ?>">
                            <div class="footer-widget-title">
                                <h5><?php echo e($footerContent['widget_title_'.$loop->iteration] ?? ''); ?></h5>
                            </div>
                            <div class="footer-link">
                                <ul>
                                    <?php $__currentLoopData = $navigation; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($menu->page_id == null): ?>
                                            <li><a href="<?php echo e($menu->url); ?>"><?php echo e($menu->tname); ?></a></li>
                                        <?php else: ?>
                                            <li><a href="<?php echo e(url($menu->url)); ?>"><?php echo e($menu->tname); ?></a></li>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <div class="col-xxl-3 col-xl-3 col-lg-3 col-md-6 col-sm-6">
                        <div class="footer-widget-1-4 justify-content-lg-end">
                            <div class="footer-widget-title">
                                <h5><?php echo e($footerContent['widget_title_3'] ?? ''); ?></h5>
                            </div>
                            <div class="footer-contact">
                                <div class="footer-info">
                                    <div class="single-item">
                                        <h6 class="title"><?php echo e($footerContent['contact_email_title']); ?></h6>
                                        <div class="footer-info-item">
                                            <div class="footer-info-icon">
                                                <span><i class="fa-solid fa-envelope"></i></span>
                                            </div>
                                            <div class="footer-info-text">
                                                <span><a
                                                        href="mailto:<?php echo e($footerContent['contact_email_address']); ?>"><?php echo e($footerContent['contact_email_address']); ?></a></span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="single-item">
                                        <h6 class="title"><?php echo e($footerContent['contact_telegram_title']); ?></h6>
                                        <div class="footer-info-item">
                                            <div class="footer-info-icon">
                                                <span><i class="fa-brands fa-telegram"></i></span>
                                            </div>
                                            <div class="footer-info-text">
                                                <span><a href="<?php echo e($footerContent['contact_telegram_link']); ?>" target="_blank"><?php echo e($footerContent['contact_telegram_link']); ?></a></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <div class="footer-bottom">
                        <div class="footer-copyright">
                            <p><?php echo e($footerContent['copyright_text']); ?></p>
                        </div>
                        <div class="footer-social">
                            <?php $__currentLoopData = \App\Models\Social::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $social): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="<?php echo e(url($social->url)); ?>"><i class="<?php echo e($social->class_name); ?>"></i></a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="footer-shapes">
            <div class="shape-one">
                <img src="<?php echo e(asset('/')); ?>/front/images/shapes/footer/shape-01.png" alt="shape not found">
            </div>
            <div class="shape-two">
                <img src="<?php echo e(asset('/')); ?>/front/images/shapes/footer/shape-02.png" alt="shape not found">
            </div>
        </div>
    </div>
</footer>
<!-- Footer area end -->
<?php /**PATH /home/oyxmpnpf/paysmart.azonetech.com.ng/app/Providers/../../resources/views/frontend/default/include/__footer.blade.php ENDPATH**/ ?>