

<?php $__env->startSection('title'); ?>
    <?php echo e(__('Login')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!-- Login Section -->
    <div class="half-authpage">
        <div class="authOne">
            <div class="auth-contents">
                <?php
                    $height = setting('site_logo_height','global') == 'auto' ? 'auto' : setting('site_logo_height','global').'px';
                    $width = setting('site_logo_width','global') == 'auto' ? 'auto' : setting('site_logo_width','global').'px';
                ?>
                <div class="logo">
                    <a href="<?php echo e(route('home')); ?>"><img src="<?php echo e(asset(setting('site_logo','global'))); ?>" style="height:<?php echo e($height); ?>;width:<?php echo e($width); ?>;max-width:none" alt=""></a>
                    <div class="no-user-header">
                        <?php if(setting('language_switcher')): ?>
                            <div class="language-switcher">
                                <select class="langu-swit small" name="language" id=""
                                        onchange="window.location.href=this.options[this.selectedIndex].value;">
                                    <?php $__currentLoopData = \App\Models\Language::where('status',true)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option
                                            value="<?php echo e(route('language-update',['name'=> $lang->locale])); ?>" <?php if( app()->getLocale() == $lang->locale ): echo 'selected'; endif; ?>><?php echo e($lang->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        <?php endif; ?>
                        <div class="color-switcher">
                            <img class="light-icon" src="<?php echo e(asset('front/images/icons/sun.png')); ?>" alt="">
                            <img class="dark-icon" src="<?php echo e(asset('front/images/icons/moon.png')); ?>" alt="">
                        </div>
                    </div>
                </div>
                <div class="contents">
                    <div class="content">
                        <h3><?php echo e($data['title']); ?></h3>
                        <?php if($errors->any()): ?>
                            <div class="error-message">
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <p><?php echo e($error); ?></p>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        <?php endif; ?>
                        <form method="POST" action="<?php echo e(route('login')); ?>">
                            <?php echo csrf_field(); ?>
                            <div class="inputs">
                                <label for=""><?php echo e(__('Email Or Username')); ?></label>
                                <input type="text" name="email" class="box-input" required>
                            </div>
                            <div class="inputs">
                                <label for=""><?php echo e(__('Password')); ?></label>
                                <div class="passo">
                                    <input type="password" class="box-input" name="password" id="passo" required>
                                    <img src="<?php echo e(asset('front/images/icons/eye-off.svg')); ?>" class="passo-hide-show"
                                         id="eyeicon" alt="">
                                </div>
                            </div>
                            <?php if($googleReCaptcha): ?>
                                <div class="g-recaptcha mb-3" id="feedback-recaptcha"
                                     data-sitekey="<?php echo e(json_decode($googleReCaptcha->data,true)['site_key']); ?>">
                                </div>
                            <?php endif; ?>
                            <div class="inputs">
                                <div class="remem-for">
                                    <div class="checkbox-wrapper-15">
                                        <input class="inp-cbx" id="cbx-15" name="remember" type="checkbox"
                                               style="display: none;"/>
                                        <label class="cbx" for="cbx-15">
                                            <span>
                                              <svg width="12px" height="9px" viewbox="0 0 12 9">
                                                <polyline points="1 5 4 8 11 1"></polyline>
                                              </svg>
                                            </span>
                                            <span> <?php echo e(__('Remember me')); ?></span>
                                        </label>
                                    </div>
                                    <?php if(Route::has('password.request')): ?>
                                        <p><a href="<?php echo e(route('password.request')); ?>"><?php echo e(__('Forget Password')); ?></a></p>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="inputs">
                                <button type="submit" class="site-btn primary-btn w-100"><i data-lucide="key"></i>
                                    <?php echo e(__('Sign in')); ?>

                                </button>
                            </div>
                        </form>
                        <p><?php echo e(__("Don't have an account?")); ?> <a
                                href="<?php echo e(route('register')); ?>"><?php echo e(__('Create account')); ?></a></p>
                    </div>
                </div>
            </div>
        </div>
        <div class="authOne">
            <div class="auth-banner" style="background: url('<?php echo e(asset($data['right_image'])); ?>') no-repeat;"></div>
        </div>
    </div>
    <!-- Login Section End -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <?php if($googleReCaptcha): ?>
        <script src="https://www.google.com/recaptcha/api.js" async defer></script>
    <?php endif; ?>
    <script>
        (function($) {
            'use strict';

            // password hide show
            let eyeicon = document.getElementById('eyeicon')
            let passo = document.getElementById('passo')
            eyeicon.onclick = function() {
                if(passo.type === "password") {
                    passo.type = "text";
                    eyeicon.src = '<?php echo e(asset('front/images/icons/eye.svg')); ?>'
                } else {
                    passo.type = "password";
                    eyeicon.src = '<?php echo e(asset('front/images/icons/eye-off.svg')); ?>'
                }
            }

        })(jQuery);
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend::layouts.auth', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/oyxmpnpf/paysmart.azonetech.com.ng/app/Providers/../../resources/views/frontend/default/auth/login.blade.php ENDPATH**/ ?>