
<?php $__env->startSection('title'); ?>
    <?php echo e(__('Manage Staff')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="main-content">
        <div class="page-title">
            <div class="container-fluid">
                <div class="row">
                    <div class="col">
                        <div class="title-content">
                            <h2 class="title"><?php echo e(__('Manage Staffs')); ?></h2>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('staff-create')): ?>
                                <a href="" class="title-btn" type="button" data-bs-toggle="modal"
                                   data-bs-target="#staffModal"><i data-lucide="plus-circle"></i><?php echo e(__('Add New Staff')); ?>

                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">

                <div class="col-xl-12">
                    <div class="site-card">
                        <div class="site-card-body">
                            <div class="site-table table-responsive">
                                <table class="table">
                                    <thead>
                                    <tr>
                                        <th scope="col"><?php echo e(__('Name')); ?></th>
                                        <th scope="col"><?php echo e(__('Email')); ?></th>
                                        <th scope="col"><?php echo e(__('Role')); ?></th>
                                        <th scope="col"><?php echo e(__('Status')); ?></th>
                                        <th scope="col"><?php echo e(__('Action')); ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $staffs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $staff): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td>
                                                <strong><?php echo e($staff->name); ?></strong>
                                            </td>
                                            <td><?php echo e($staff->email); ?></td>
                                            <td><strong
                                                    class="site-badge primary"><?php echo e($staff->getRoleNames()->first()); ?></strong>
                                            </td>
                                            <td>
                                                <?php if($staff->status): ?>
                                                    <div class="site-badge success"><?php echo e(__('Active')); ?></div>
                                                <?php else: ?>
                                                    <div class="site-badge danger"><?php echo e(__('InActive')); ?></div>
                                                <?php endif; ?>

                                            </td>
                                            <td>
                                                <?php if($staff->getRoleNames()->first() === 'Super-Admin'): ?>
                                                    <button class="round-icon-btn red-btn" type="button"
                                                            data-bs-toggle="tooltip" title="" data-bs-placement="top"
                                                            data-bs-original-title="Not Editable">
                                                        <i data-lucide="edit-3"></i>
                                                    </button>
                                                <?php else: ?>
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('staff-edit')): ?>
                                                        <button class="round-icon-btn primary-btn"
                                                                data-id="<?php echo e($staff->id); ?>" type="button" id="edit"
                                                                data-bs-toggle="tooltip" title=""
                                                                data-bs-placement="top"
                                                                data-bs-original-title="Edit Staff">
                                                            <i data-lucide="edit-3"></i>
                                                        </button>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <td colspan="5" class="text-cener"><?php echo e(__('No Data Found!')); ?></td>
                                    <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Modal for Add New Staff -->
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('staff-create')): ?>
            <?php echo $__env->make('backend.staff.modal.__new_staff', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
        <!-- Modal for Add New Staff-->

        <!-- Modal for Edit Staff -->
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('staff-edit')): ?>
            <?php echo $__env->make('backend.staff.modal.__edit_staff', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
        <!-- Modal for Edit Staff-->

    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        let loader = '<div class="text-center"><img src="<?php echo e(asset('front/images/loader.gif')); ?>" width="100"><h5><?php echo e(__('Please wait')); ?>...</h5></div>';

        $('body').on('click', '#edit', function (event) {
            "use strict";
            event.preventDefault();
            $('#edit-staff-body').html(loader);
            $('#editModal').modal('show');
            var id = $(this).data('id');

            $.get('staff/' + id + '/edit', function (data) {

                $('#edit-staff-body').html(data);

            })
        })

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/oyxmpnpf/paysmart.azonetech.com.ng/resources/views/backend/staff/index.blade.php ENDPATH**/ ?>