<?php if(request('tab') == 'transactions'): ?>
<div
    class="<?php echo \Illuminate\Support\Arr::toCssClasses([
        'tab-pane fade',
        'show active' => request('tab') == 'transactions'
    ]); ?>"
    id="pills-transactions"
    role="tabpanel"
    aria-labelledby="pills-transactions-tab"
>
    <div class="row">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
            <div class="site-card">
                <div class="site-card-header">
                    <h4 class="title"><?php echo e(__('Transactions')); ?></h4>
                </div>
                <div class="site-card-body table-responsive">
                    <div class="site-table">
                        <div class="table-filter">
                            <form action="" method="get">
                                <input type="hidden" name="tab" value="transactions">
                                <div class="filter d-flex">
                                    <div class="search">
                                        <label for=""><?php echo e(__('Search:')); ?></label>
                                        <input type="text" name="query" value="<?php echo e(request('query')); ?>"/>
                                    </div>
                                    <button class="apply-btn" type="submit"><i data-lucide="search"></i><?php echo e(__('Search')); ?></button>
                                </div>
                            </form>
                        </div>
                        <table class="table">
                            <thead>
                            <tr>
                                <?php echo $__env->make('backend.filter.th',['label' => 'Date','field' => 'created_at'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php echo $__env->make('backend.filter.th',['label' => 'Transaction ID','field' => 'tnx'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php echo $__env->make('backend.filter.th',['label' => 'Type','field' => 'type'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php echo $__env->make('backend.filter.th',['label' => 'Amount','field' => 'final_amount'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php echo $__env->make('backend.filter.th',['label' => 'Gateway','field' => 'method'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php echo $__env->make('backend.filter.th',['label' => 'Status','field' => 'status'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($transaction->created_at); ?></td>
                                    <td><?php echo e($transaction->tnx); ?></td>
                                    <td>
                                        <?php echo $__env->make('backend.transaction.include.__txn_type',[ 'txnType' => $transaction->type->value], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </td>
                                    <td>
                                        <?php echo $__env->make('backend.transaction.include.__txn_amount',['amount' => $transaction->final_amount,'txnType' => $transaction->type->value], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </td>
                                    <td><?php echo e($transaction->method); ?></td>
                                    <td>
                                        <?php echo $__env->make('backend.user.include.__txn_status',['status' => $transaction->status->value], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <td colspan="7" class="text-center"><?php echo e(__('No Data Found!')); ?></td>
                                <?php endif; ?>
                            </tbody>
                        </table>
                        <?php echo e($transactions->links()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>
<?php /**PATH /home/oyxmpnpf/paysmart.azonetech.com.ng/resources/views/backend/user/include/__transactions.blade.php ENDPATH**/ ?>