<?php if(request('tab') == 'card'): ?>
<div class="<?php echo \Illuminate\Support\Arr::toCssClasses([ 'tab-pane fade' , 'show active'=> request('tab') == 'card'
    ]); ?>"
    id="pills-loan"
    role="tabpanel"
    aria-labelledby="pills-loan-tab"
    >
    <div class="row">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
            <div class="site-card">
                <div class="site-card-header">
                    <h4 class="title"><?php echo e(__('Virtual Card')); ?></h4>
                </div>
                <div class="site-card-body">
                    <div class="row">
                        <?php $__currentLoopData = $cards; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $card): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-xl-6">
                                <div class="site-card">
                                    <div class="site-card-body">
                                        <div class="profile-text-data">
                                            <div class="attribute"><?php echo e(__('Cardholder Name')); ?></div>
                                            <div class="value">
                                                <?php echo e($card?->cardHolder?->name); ?>

                                            </div>
                                        </div>
                                        <div class="profile-text-data">
                                            <div class="attribute"><?php echo e(__('Card Number')); ?></div>
                                            <div class="value">
                                                **** **** **** <?php echo e($card?->last_four_digits); ?>

                                            </div>
                                        </div>
                                        <div class="profile-text-data">
                                            <div class="attribute"><?php echo e(__('Card Expiry')); ?></div>
                                            <div class="value">
                                                <?php echo e($card?->expiration_month); ?> / <?php echo e($card?->expiration_year); ?>

                                            </div>
                                        </div>
                                        <div class="profile-text-data">
                                            <div class="attribute"><?php echo e(__('Card Balance')); ?></div>
                                            <div class="value">
                                                <?php echo e(setting('currency_symbol','global') . $card->amount); ?>

                                            </div>
                                        </div>
                                        <div class="profile-text-data">
                                            <div class="attribute"><?php echo e(__('Card Status')); ?></div>
                                            <div class="value">
                                                <div
                                                    class="site-badge <?php echo e($card?->status == 'active' ? 'success':'danger'); ?>">
                                                    <?php echo e(ucfirst($card?->status)); ?>

                                                </div>
                                            </div>
                                        </div>
                                        <div class="d-flex">
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('virtual-card-status-change')): ?>
                                            <a href="<?php echo e(route('admin.user.card.status.update', $card->card_id)); ?>"
                                                class="site-btn-sm <?php echo e($card?->status == 'active' ? 'red':'green'); ?>-btn">
                                                <?php echo $card->status == 'active' ? '<i data-lucide="shield-off"></i>'.__('Deactivate') : '<i data-lucide="shield-check"></i>'.__('Activate'); ?>

                                            </a>
                                            &nbsp;
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('virtual-card-topup')): ?>
                                            <button type="button" class="site-btn-sm primary-btn" data-bs-toggle="modal" data-bs-target="#topUpCard_<?php echo e($card->id); ?>">
                                                <i data-lucide="plus-circle"></i> <?php echo e(__('Top Up Card')); ?>

                                            </button>
                                            <?php endif; ?>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('virtual-card-topup')): ?>
                            <div class="modal fade" id="topUpCard_<?php echo e($card->id); ?>" tabindex="-1" aria-labelledby="addSubBalLabel" aria-hidden="true">
                                <div class="modal-dialog modal-md modal-dialog-centered">
                                    <div class="modal-content site-table-modal">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="addSubBalLabel">
                                                <?php echo e(__('Card Top Up')); ?>

                                            </h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                        </div>
                                        <div class="modal-body">
                                            <form action="<?php echo e(route('admin.user.card.balance.update', $card->id)); ?>" method="post">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('PUT'); ?>
                                                <div class="row">
                                                    <div class="col-xl-12">
                                                        <div class="site-input-groups">
                                                            <label for="wallet" class="input-label mb-1">
                                                                <?php echo e(__('Amount')); ?>

                                                                <span class="required">*</span>
                                                            </label>
                                                            <div class="input-group joint-input">
                                                                <span class="input-group-text"><?php echo e(setting('site_currency','global')); ?></span>
                                                                <input type="text" name="amount" oninput="this.value = validateDouble(this.value)"
                                                                    class="form-control">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-xl-12">
                                                        <button type="submit" class="site-btn-sm primary-btn w-100">
                                                            <?php echo e(__('Apply Now')); ?>

                                                        </button>
                                                    </div>
                                                </div>
                                            </form>

                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>
<?php /**PATH /home/oyxmpnpf/paysmart.azonetech.com.ng/resources/views/backend/user/include/__card.blade.php ENDPATH**/ ?>