<?php use App\Enums\TxnStatus; ?>

<?php $__env->startSection('title'); ?>
    <?php echo e(__('Transactions')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('style'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('front/css/daterangepicker.css')); ?>">
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-xl-12 col-lg-12 col-md-12 col-12">
            <div class="site-card">
                <div class="site-card-header">
                    <div class="title-small"><?php echo e(__('All Transactions')); ?></div>
                </div>
                <div class="site-card-body p-0 overflow-x-auto">
                    <form>
                        <div class="table-filter">
                            <div class="filter">
                                <div class="single-f-box">
                                    <label for=""><?php echo e(__('Transaction ID')); ?></label>
                                    <input class="search" type="text" name="trx" value="<?php echo e(request('trx')); ?>"
                                        autocomplete="off" />
                                </div>
                                <div class="single-f-box">
                                    <label for=""><?php echo e(__('Type')); ?></label>
                                    <select name="type" class="nice-select page-count w-100 ">
                                        <option value="all" <?php if(request('type') == 'all'): echo 'selected'; endif; ?>><?php echo e(__('All Type')); ?></option>
                                        <option value="deposit" <?php if(request('type') == 'deposit'): echo 'selected'; endif; ?>><?php echo e(__('Deposit')); ?></option>
                                        <option value="fund_transfer" <?php if(request('type') == 'fund_transfer'): echo 'selected'; endif; ?>><?php echo e(__('Fund Transfer')); ?>

                                        </option>
                                        <option value="dps" <?php if(request('type') == 'dps'): echo 'selected'; endif; ?>><?php echo e(__('DPS')); ?></option>
                                        <option value="fdr" <?php if(request('type') == 'fdr'): echo 'selected'; endif; ?>><?php echo e(__('FDR')); ?></option>
                                        <option value="loan" <?php if(request('type') == 'loan'): echo 'selected'; endif; ?>><?php echo e(__('Loan')); ?></option>
                                        <option value="pay_bill" <?php if(request('type') == 'pay_bill'): echo 'selected'; endif; ?>><?php echo e(__('Pay Bill')); ?></option>
                                        <option value="withdraw" <?php if(request('type') == 'withdraw'): echo 'selected'; endif; ?>><?php echo e(__('Withdraw')); ?></option>
                                        <option value="referral" <?php if(request('type') == 'referral'): echo 'selected'; endif; ?>><?php echo e(__('Referral')); ?></option>
                                        <option value="portfolio" <?php if(request('type') == 'portfolio'): echo 'selected'; endif; ?>><?php echo e(__('Portfolio')); ?>

                                        </option>
                                        <option value="rewards" <?php if(request('type') == 'rewards'): echo 'selected'; endif; ?>><?php echo e(__('Rewards')); ?></option>
                                    </select>
                                </div>
                                <div class="single-f-box">
                                    <label for=""><?php echo e(__('Date')); ?></label>
                                    <input type="text" name="daterange" value="<?php echo e(request('daterange')); ?>"
                                        autocomplete="off" />
                                </div>
                                <button class="apply-btn me-2" name="filter">
                                    <i data-lucide="filter"></i><?php echo e(__('Filter')); ?>

                                </button>
                                <?php if(request()->has('filter')): ?>
                                    <button type="button" class="apply-btn bg-danger reset-filter">
                                        <i data-lucide="x"></i><?php echo e(__('Reset Filter')); ?>

                                    </button>
                                <?php endif; ?>
                            </div>
                            <div class="filter">
                                <div class="single-f-box w-auto ms-4 me-0">
                                    <label for=""><?php echo e(__('Entries')); ?></label>
                                    <select name="limit" class="nice-select page-count" id="limit-select">
                                        <option value="15" <?php if(request('limit', 15) == '15'): echo 'selected'; endif; ?>>15</option>
                                        <option value="30" <?php if(request('limit') == '30'): echo 'selected'; endif; ?>>30</option>
                                        <option value="50" <?php if(request('limit') == '50'): echo 'selected'; endif; ?>>50</option>
                                        <option value="100" <?php if(request('limit') == '100'): echo 'selected'; endif; ?>>100</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </form>
                    <div class="site-custom-table">
                        <div class="contents">
                            <div class="site-table-list site-table-head">
                                <div class="site-table-col"><?php echo e(__('Description')); ?></div>
                                <div class="site-table-col"><?php echo e(__('Transactions ID')); ?></div>
                                <div class="site-table-col"><?php echo e(__('Type')); ?></div>
                                <div class="site-table-col"><?php echo e(__('Amount')); ?></div>
                                <div class="site-table-col"><?php echo e(__('Charge')); ?></div>
                                <div class="site-table-col"><?php echo e(__('Status')); ?></div>
                                <div class="site-table-col"><?php echo e(__('Method')); ?></div>
                                <div class="site-table-col"><?php echo e(__('View')); ?></div>
                            </div>
                            <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="site-table-list">
                                    <div class="site-table-col">
                                        <div class="description">
                                            <div class="event-icon">
                                                <?php if($transaction->type->value == 'deposit' || $transaction->type->value == 'manual_deposit'): ?>
                                                    <i data-lucide="chevrons-down"></i>
                                                <?php elseif(Str::startsWith($transaction->type->value, 'dps')): ?>
                                                    <i data-lucide="archive"></i>
                                                <?php elseif(Str::startsWith($transaction->type->value, 'fdr')): ?>
                                                    <i data-lucide="book"></i>
                                                <?php elseif(Str::startsWith($transaction->type->value, 'loan')): ?>
                                                    <i data-lucide="alert-triangle"></i>
                                                <?php elseif($transaction->type->value == 'subtract'): ?>
                                                    <i data-lucide="minus-circle"></i>
                                                <?php elseif($transaction->type->value == 'receive_money'): ?>
                                                    <i data-lucide="arrow-down-left"></i>
                                                <?php elseif($transaction->type->value == 'reward_redeem'): ?>
                                                    <i data-lucide="gift"></i>
                                                <?php else: ?>
                                                    <i data-lucide="send"></i>
                                                <?php endif; ?>
                                            </div>
                                            <div class="content">
                                                <div class="title">
                                                    <?php echo e($transaction->description); ?>

                                                    <?php if(!in_array($transaction->approval_cause, ['none', ''])): ?>
                                                        <span class="msg" data-bs-toggle="tooltip"
                                                            data-bs-custom-class="custom-tooltip" data-bs-placement="top"
                                                            data-bs-title="<?php echo e($transaction->approval_cause); ?>"><i
                                                                data-lucide="message-square"></i>
                                                        </span>
                                                    <?php endif; ?>
                                                </div>
                                                <div class="date"><?php echo e($transaction->created_at); ?></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="site-table-col">
                                        <div class="trx fw-bold"><?php echo e($transaction->tnx); ?></div>
                                    </div>
                                    <div class="site-table-col">
                                        <div class="type site-badge badge-primary">
                                            <?php echo e(ucfirst(str_replace('_', ' ', $transaction->type->value))); ?></div>
                                    </div>
                                    <div class="site-table-col">
                                        <div class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                            'fw-bold',
                                            'green-color' => isPlusTransaction($transaction->type) == true,
                                            'red-color' => isPlusTransaction($transaction->type) == false,
                                        ]); ?>">
                                            <?php echo e(isPlusTransaction($transaction->type) == true ? '+' : '-'); ?><?php echo e($transaction->amount . ' ' . $currency); ?>

                                        </div>
                                    </div>
                                    <div class="site-table-col">
                                        <div class="fw-bold red-color">-<?php echo e($transaction->charge . ' ' . $currency); ?></div>
                                    </div>
                                    <div class="site-table-col">
                                        <?php if($transaction->status->value == 'failed'): ?>
                                            <div class="type site-badge badge-failed"><?php echo e($transaction->status->value); ?>

                                            </div>
                                        <?php elseif($transaction->status->value == 'success'): ?>
                                            <div class="type site-badge badge-success"><?php echo e($transaction->status->value); ?>

                                            </div>
                                        <?php elseif($transaction->status->value == 'pending'): ?>
                                            <div class="type site-badge badge-pending"><?php echo e($transaction->status->value); ?>

                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="site-table-col">
                                        <div class="fw-bold">
                                            <?php echo e($transaction->method !== '' ? ucfirst(str_replace('-', ' ', $transaction->method)) : __('System')); ?>

                                        </div>
                                    </div>
                                    <div class="site-table-col">
                                        <div class="action">
                                            <a href="javascript:void(0)" class="icon-btn details-btn"
                                                data-bs-toggle="modal" data-bs-target="#trxViewDetailsBox"
                                                data-title="<?php echo e($transaction->description); ?>"
                                                data-type="<?php echo e($transaction->type->value); ?>"
                                                data-time="<?php echo e($transaction->created_at); ?>"
                                                data-transaction-id="<?php echo e($transaction->tnx); ?>"
                                                data-transaction="<?php echo e($transaction->manual_field_data); ?>"
                                                data-message="<?php echo e($transaction->action_message); ?>"
                                                data-amount="<?php echo e(isPlusTransaction($transaction->type) == true ? '+' : '-'); ?><?php echo e($transaction->amount . ' ' . $currency); ?>"
                                                data-charge="<?php echo e($transaction->charge . ' ' . $currency); ?>"
                                                data-status="<?php echo e($transaction->status->value); ?>"
                                                data-method="<?php echo e($transaction->method !== '' ? ucfirst(str_replace('-', ' ', $transaction->method)) : __('System')); ?>">
                                                <i data-lucide="eye"></i><?php echo e(__('Details')); ?>

                                            </a>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <?php if(count($transactions) == 0): ?>
                            <div class="no-data-found"><?php echo e(__('No Data Found')); ?></div>
                        <?php endif; ?>
                    </div>

                    <!-- Modal for Transaction View Details -->
                    <div class="modal fade" id="trxViewDetailsBox" tabindex="-1"
                        aria-labelledby="trxViewDetailsBoxModalLabel" aria-hidden="true">
                        <div class="modal-dialog modal-md modal-dialog-centered">
                            <div class="modal-content site-table-modal">
                                <div class="modal-body popup-body">
                                    <button type="button" class="modal-btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"><i data-lucide="x"></i></button>
                                    <div class="popup-body-text">
                                        <div class="title title-value"></div>
                                        <div class="modal-beneficiary-details">
                                            <div class="profile-text-data">
                                                <div class="attribute"><?php echo e(__('Time')); ?></div>
                                                <div class="value time-value"></div>
                                            </div>
                                            <div class="profile-text-data">
                                                <div class="attribute"><?php echo e(__('Transaction ID')); ?></div>
                                                <div class="value trx-value"></div>
                                            </div>
                                            <div class="profile-text-data">
                                                <div class="attribute"><?php echo e(__('Amount')); ?></div>
                                                <div class="value green-color amount-value"></div>
                                            </div>
                                            <div class="profile-text-data">
                                                <div class="attribute"><?php echo e(__('Charge')); ?></div>
                                                <div class="value red-color charge-value"></div>
                                            </div>
                                            <div class="profile-text-data">
                                                <div class="attribute"><?php echo e(__('Status')); ?></div>
                                                <div class="value status-value"></div>
                                            </div>
                                            <div class="profile-text-data">
                                                <div class="attribute"><?php echo e(__('Method')); ?></div>
                                                <div class="value method-value"></div>
                                            </div>
                                            <div class="custom-fields"></div>

                                            <div class="profile-text-data">
                                                <div class="attribute message-value"></div>
                                            </div>
                                        </div>
                                        <div class="action-btns mt-3">
                                            <a href="" class="site-btn-sm polis-btn" data-bs-dismiss="modal"
                                                aria-label="Close">
                                                <i data-lucide="check"></i>
                                                <?php echo e(__('Close it')); ?>

                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Modal for Transaction View Details end-->

                    <?php echo e($transactions->links()); ?>

                </div>
            </div>
        </div>
    </div>
    <?php $__env->startPush('js'); ?>
        <script src="<?php echo e(asset('front/js/moment.min.js')); ?>"></script>
        <script src="<?php echo e(asset('front/js/daterangepicker.min.js')); ?>"></script>
        <script>
            // Initialize datepicker
            $('input[name="daterange"]').daterangepicker({
                opens: 'left'
            });

            <?php if(request('daterange') == null): ?>
                // Set default is empty for date range
                $('input[name=daterange]').val('');
            <?php endif; ?>

            function capitalizeFirstLetter(string) {
                return string.charAt(0).toUpperCase() + string.slice(1);
            }

            // Set data for modal
            $(document).on('click', '.details-btn', function(e) {

                e.preventDefault();

                var id = $(this).data('id');
                var title = $(this).data('title');
                var type = $(this).data('type');
                var time = $(this).data('time');
                var trx = $(this).data('transaction-id');
                var amount = $(this).data('amount');
                var charge = $(this).data('charge');
                var method = $(this).data('method');
                var status = $(this).data('status');
                var transaction = $(this).data('transaction');

                var statusElement = '';
                var additionalData = '';

                $.each(transaction, function(key, value) {
                    additionalData += '<div class="profile-text-data"><div class="attribute">' +
                        capitalizeFirstLetter(key.replaceAll('_', ' ')) + '</div><div class="value">' + value +
                        '</div></div>';
                });

                if (status == 'failed') {
                    statusElement += `<div class="type site-badge badge-failed"><?php echo e(__('Failed')); ?></div>`
                } else if (status == 'success') {
                    statusElement += `<div class="type site-badge badge-success"><?php echo e(__('Success')); ?></div>`
                } else {
                    statusElement += `<div class="type site-badge badge-pending"><?php echo e(__('Pending')); ?></div>`
                }

                $('.title-value').text(title);
                $('.trx-value').text(trx);
                $('.time-value').text(time);
                $('.amount-value').text(amount);
                $('.charge-value').text(charge);
                $('.method-value').text(method);
                $('.status-value').html(statusElement);

                $('.custom-fields').html(additionalData);

            });

            // Reset filter
            $('.reset-filter').on('click', function() {
                window.location.href = "<?php echo e(route('user.transactions')); ?>";
            });

            $('#limit-select').on('change', function() {
                const url = new URL(window.location.href);
                url.searchParams.set('limit', $(this).val());
                window.location.href = url.toString();
            });
        </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend::layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/oyxmpnpf/paysmart.azonetech.com.ng/app/Providers/../../resources/views/frontend/default/user/transaction/index.blade.php ENDPATH**/ ?>