
<?php $__env->startSection('title'); ?>
    <?php echo e(__('Dashboard')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

    <div class="row">
        <div class="col-xl-4 col-lg-12 col-md-12 col-12">
            <div class="user-profile-card">
                <?php if(setting('user_portfolio', 'permission') && Auth::user()->portfolio_status && auth()->user()->portfolio_id != null): ?>
                <div class="badge">
                    <a href="<?php echo e(route('user.portfolio')); ?>" data-bs-toggle="tooltip" data-bs-custom-class="custom-tooltip" data-bs-placement="top" data-bs-title="<?php echo e(auth()->user()->portfolio?->portfolio_name); ?>">
                        <img src="<?php echo e(asset(auth()->user()->portfolio?->icon)); ?>" alt="">
                    </a>
                </div>
                <?php endif; ?>

                <input type="hidden" id="refLink" value="<?php echo e(auth()->user()->account_number); ?>">

                <h4 class="title"><?php echo e(__('Default Account')); ?></h4>

                <h3 class="acc-balance" id="passo">
                    <?php echo e(setting('currency_symbol','global').number_format($user->balance,2)); ?>

                </h3>

                <div class="acc-num">A/C:
                    <strong><?php echo e(auth()->user()->account_number); ?></strong>
                    <span id="copy" data-bs-toggle="tooltip" data-bs-custom-class="custom-tooltip" data-bs-placement="right" data-bs-title="Copy"><i data-lucide="copy"></i></span>
                </div>

                <?php
                    $last_login = auth()->user()->activities->last();
                    $browser = getBrowser($last_login?->agent);
                ?>
                <?php if($last_login): ?>
                <div class="last-login"><?php echo e(__('Last Login At')); ?> <?php echo e($last_login?->created_at->format('d M, h:i A')); ?>. <?php echo e(data_get($browser,'platform')); ?> . <?php echo e(data_get($browser,'browser')); ?></div>
                <?php endif; ?>
                <div class="buttons">
                    <?php if(setting('multiple_currency', 'permission')): ?>
                    <a href="<?php echo e(route('user.all-wallets')); ?>" class="send me-2"><i data-lucide="credit-card"></i><?php echo e(__('All Wallets')); ?></a>
                    <?php endif; ?>
                    <a href="<?php echo e(route('user.deposit.amount')); ?>" class="add"><i data-lucide="plus-circle"></i><?php echo e(__('Add Money')); ?></a>
                </div>
                <div class="o">O</div>
            </div>
        </div>
        <div class="col-xl-8 col-lg-12 col-md-12 col-12">
            <div class="row">
                <?php if(setting('user_dps','permission')): ?>
                <div class="col-xl-4 col-lg-4 col-md-6 col-12">
                    <div class="single-spec-stat">
                        <div class="top">
                            <div class="icon">
                                <i data-lucide="archive"></i>
                            </div>
                            <div class="title"><?php echo e(__('My DPS')); ?></div>
                        </div>
                        <div class="text">
                            <?php if($total_running_dps > 0): ?>
                            <p><?php echo e(__('DPS will be end by')); ?> <strong><?php echo e($dps_last_date); ?></strong> <?php echo e(__('and fund will be added on your account.')); ?></p>
                            <?php else: ?>
                            <p><?php echo e(__('Currently No DPS Found.')); ?></p>
                            <?php endif; ?>
                        </div>
                        <div class="bottom">
                            <?php if($total_running_dps > 0): ?>
                            <div class="amount"><?php echo e($currencySymbol.number_format(getTotalMature($user->dps->first()),2)); ?></div>
                            <?php else: ?>
                            <div class="amount"><?php echo e($currencySymbol.number_format(0,2)); ?></div>
                            <?php endif; ?>
                            <a href="<?php echo e(route('user.dps.history')); ?>" class="ex-link"><i data-lucide="arrow-up-right"></i></a>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
                <?php if(setting('user_fdr','permission')): ?>
                <div class="col-xl-4 col-lg-4 col-md-6 col-12">
                    <div class="single-spec-stat">
                        <div class="top">
                            <div class="icon">
                                <i data-lucide="book"></i>
                            </div>
                            <div class="title">
                                <?php echo e(__('My FDR')); ?>

                            </div>
                        </div>
                        <div class="text">
                            <?php if($total_running_fdr > 0): ?>
                            <p><?php echo e(__('FDR will be end by ')); ?><strong><?php echo e($fdr_last_date); ?></strong><?php echo e(__(' and fund will be added on your account.')); ?></p>
                            <?php else: ?>
                            <p><?php echo e(__('Currently No FDR Found.')); ?></p>
                            <?php endif; ?>
                        </div>
                        <div class="bottom">
                            <?php if($total_running_fdr > 0): ?>
                            <div class="amount"><?php echo e($currencySymbol.number_format($user->fdr->first()->transactions->sum('given_amount'),2)); ?></div>
                            <?php else: ?>
                            <div class="amount"><?php echo e($currencySymbol.number_format(0,2)); ?></div>
                            <?php endif; ?>
                            <a href="<?php echo e(route('user.fdr.history')); ?>" class="ex-link"><i data-lucide="arrow-up-right"></i></a>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
                <?php if(setting('user_loan','permission')): ?>
                <div class="col-xl-4 col-lg-4 col-md-6 col-12">
                    <div class="single-spec-stat">
                        <div class="top">
                            <div class="icon">
                                <i data-lucide="alert-triangle"></i>
                            </div>
                            <div class="title"><?php echo e(__('My Loan')); ?></div>
                        </div>
                        <div class="text">
                            <?php if($total_running_loan > 0): ?>
                            <p><?php echo e(__('Your Loan will be closed on')); ?> <strong><?php echo e($loan_last_date); ?></strong>, <?php echo e(__('Need to payback continuously.')); ?></p>
                            <?php else: ?>
                            <p><?php echo e(__('Currently No Loan Found.')); ?></p>
                            <?php endif; ?>
                        </div>
                        <div class="bottom">
                            <?php if($total_running_loan > 0): ?>
                            <div class="amount"><?php echo e($currencySymbol.number_format($user->loan->first()->totalPayableAmount(),2)); ?></div>
                            <?php else: ?>
                            <div class="amount"><?php echo e($currencySymbol.number_format(0,2)); ?></div>
                            <?php endif; ?>
                            <a href="<?php echo e(route('user.loan.history')); ?>" class="ex-link"><i data-lucide="arrow-up-right"></i></a>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-xl-3 col-lg-3 col-md-6 col-12">
            <div class="single-user-stat-card">
                <div class="icon">
                    <img src="<?php echo e(asset('front/images/icons/fintech/1.png')); ?>" alt="">
                </div>
                <div class="number"><?php echo e($total_transaction); ?></div>
                <div class="title"><?php echo e(__('All Transactions')); ?></div>
            </div>
        </div>
        <div class="col-xl-3 col-lg-3 col-md-6 col-12">
            <div class="single-user-stat-card">
                <div class="icon">
                    <img src="<?php echo e(asset('front/images/icons/fintech/2.png')); ?>" alt="">
                </div>
                <div class="number"><?php echo e($total_deposit); ?> <?php echo e($currency); ?></div>
                <div class="title"><?php echo e(__('Total Deposit')); ?></div>
            </div>
        </div>
        <?php if(setting('transfer_status','permission')): ?>
        <div class="col-xl-3 col-lg-3 col-md-6 col-12">
            <div class="single-user-stat-card">
                <div class="icon">
                    <img src="<?php echo e(asset('front/images/icons/fintech/3.png')); ?>" alt="">
                </div>
                <div class="number"><?php echo e($total_transfer); ?> <?php echo e($currency); ?></div>
                <div class="title"><?php echo e(__('Total Transfer')); ?></div>
            </div>
        </div>
        <?php endif; ?>
        <?php if(setting('user_pay_bill','permission')): ?>
        <div class="col-xl-3 col-lg-3 col-md-6 col-12">
            <div class="single-user-stat-card">
                <div class="icon">
                    <img src="<?php echo e(asset('front/images/icons/fintech/9.png')); ?>" alt="">
                </div>
                <div class="number"><?php echo e($total_bill); ?></div>
                <div class="title"><?php echo e(__('Total Pay Bill')); ?></div>
            </div>
        </div>
        <?php endif; ?>
        <div class="col-xl-3 col-lg-3 col-md-6 col-12">
            <div class="single-user-stat-card">
                <div class="icon">
                    <img src="<?php echo e(asset('front/images/icons/fintech/4.png')); ?>" alt="">
                </div>
                <div class="number"><?php echo e($total_referral_profit); ?> <?php echo e($currency); ?></div>
                <div class="title"><?php echo e(__('Referral Bonus')); ?></div>
            </div>
        </div>
        <?php if(setting('user_dps','permission')): ?>
        <div class="col-xl-3 col-lg-3 col-md-6 col-12">
            <div class="single-user-stat-card">
                <div class="icon">
                    <img src="<?php echo e(asset('front/images/icons/fintech/5.png')); ?>" alt="">
                </div>
                <div class="number"><?php echo e($total_dps); ?></div>
                <div class="title"><?php echo e(__('Total DPS')); ?></div>
            </div>
        </div>
        <?php endif; ?>
        <?php if(setting('user_fdr','permission')): ?>
        <div class="col-xl-3 col-lg-3 col-md-6 col-12">
            <div class="single-user-stat-card">
                <div class="icon">
                    <img src="<?php echo e(asset('front/images/icons/fintech/6.png')); ?>" alt="">
                </div>
                <div class="number"><?php echo e($total_fdr); ?></div>
                <div class="title"><?php echo e(__('Total FDR')); ?></div>
            </div>
        </div>
        <?php endif; ?>
        <?php if(setting('user_loan','permission')): ?>
        <div class="col-xl-3 col-lg-3 col-md-6 col-12">
            <div class="single-user-stat-card">
                <div class="icon">
                    <img src="<?php echo e(asset('front/images/icons/fintech/7.png')); ?>" alt="">
                </div>
                <div class="number"><?php echo e($total_loan); ?></div>
                <div class="title"><?php echo e(__('Total Loan')); ?></div>
            </div>
        </div>
        <?php endif; ?>
        <div class="col-xl-3 col-lg-3 col-md-6 col-12">
            <div class="single-user-stat-card">
                <div class="icon">
                    <img src="<?php echo e(asset('front/images/icons/fintech/8.png')); ?>" alt="">
                </div>
                <div class="number"><?php echo e($deposit_bonus); ?> <?php echo e($currency); ?></div>
                <div class="title"><?php echo e(__('Deposit Bonus')); ?></div>
            </div>
        </div>
        <?php if(setting('sign_up_referral','permission')): ?>
        <div class="col-xl-3 col-lg-3 col-md-6 col-12">
            <div class="single-user-stat-card">
                <div class="icon">
                    <img src="<?php echo e(asset('front/images/icons/fintech/10.png')); ?>" alt="">
                </div>
                <div class="number"><?php echo e($total_referral); ?></div>
                <div class="title"><?php echo e(__('Total Referral')); ?></div>
            </div>
        </div>
        <?php endif; ?>
        <div class="col-xl-3 col-lg-3 col-md-6 col-12">
            <div class="single-user-stat-card">
                <div class="icon">
                    <img src="<?php echo e(asset('front/images/icons/fintech/11.png')); ?>" alt="">
                </div>
                <div class="number"><?php echo e($total_withdraw); ?> <?php echo e($currency); ?></div>
                <div class="title"><?php echo e(__('Total Withdraw')); ?></div>
            </div>
        </div>
        <div class="col-xl-3 col-lg-3 col-md-6 col-12">
            <div class="single-user-stat-card">
                <div class="icon">
                    <img src="<?php echo e(asset('front/images/icons/fintech/12.png')); ?>" alt="">
                </div>
                <div class="number"><?php echo e($total_tickets); ?></div>
                <div class="title"><?php echo e(__('Total Ticket')); ?></div>
            </div>
        </div>
        <div class="col-xl-12 col-lg-12 col-md-12 col-12">
            <div class="site-card">
                <div class="site-card-header">
                    <div class="title-small"><?php echo e(__('Recent Transactions')); ?></div>
                    <div class="card-header-links">
                        <a href="<?php echo e(route('user.transactions')); ?>" class="card-header-link"><i data-lucide="eye"></i><?php echo e(__('See All')); ?></a>
                    </div>
                </div>
                <div class="site-card-body p-0 overflow-x-auto">
                    <div class="site-custom-table">
                        <div class="contents">
                            <div class="site-table-list site-table-head">
                                <div class="site-table-col"><?php echo e(__('Description')); ?></div>
                                <div class="site-table-col"><?php echo e(__('Transactions ID')); ?></div>
                                <div class="site-table-col"><?php echo e(__('Type')); ?></div>
                                <div class="site-table-col"><?php echo e(__('Amount')); ?></div>
                                <div class="site-table-col"><?php echo e(__('Charge')); ?></div>
                                <div class="site-table-col"><?php echo e(__('Status')); ?></div>
                                <div class="site-table-col"><?php echo e(__('Method')); ?></div>
                            </div>
                            <?php $__currentLoopData = $recentTransactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="site-table-list">
                                <div class="site-table-col">
                                    <div class="description">
                                        <div class="event-icon">
                                            <?php if($transaction->type->value == 'deposit' || $transaction->type->value == 'manual_deposit'): ?>
                                            <i data-lucide="chevrons-down"></i>
                                            <?php elseif(Str::startsWith($transaction->type->value ,'dps')): ?>
                                            <i data-lucide="archive"></i>
                                            <?php elseif(Str::startsWith($transaction->type->value ,'fdr')): ?>
                                            <i data-lucide="book"></i>
                                            <?php elseif(Str::startsWith($transaction->type->value ,'loan')): ?>
                                            <i data-lucide="alert-triangle"></i>
                                            <?php elseif($transaction->type->value == 'subtract'): ?>
                                            <i data-lucide="minus-circle"></i>
                                            <?php elseif($transaction->type->value == 'receive_money'): ?>
                                            <i data-lucide="arrow-down-left"></i>
                                            <?php else: ?>
                                            <i data-lucide="send"></i>
                                            <?php endif; ?>
                                        </div>
                                        <div class="content">
                                            <div class="title">
                                                <?php echo e($transaction->description); ?>

                                                <?php if(!in_array($transaction->approval_cause,['none',""])): ?>
                                                <span class="msg" data-bs-toggle="tooltip"
                                                    data-bs-custom-class="custom-tooltip" data-bs-placement="top"
                                                    data-bs-title="<?php echo e($transaction->approval_cause); ?>"><i
                                                        data-lucide="message-square"></i>
                                                </span>
                                                <?php endif; ?>
                                            </div>
                                            <div class="date"><?php echo e($transaction->created_at); ?></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="site-table-col">
                                    <div class="trx fw-bold"><?php echo e($transaction->tnx); ?></div>
                                </div>
                                <div class="site-table-col">
                                    <div class="type site-badge badge-primary"><?php echo e(ucfirst(str_replace('_',' ',$transaction->type->value))); ?></div>
                                </div>
                                <div class="site-table-col">
                                    <div class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                        "fw-bold",
                                        "green-color" => isPlusTransaction($transaction->type) == true,
                                        "red-color" => isPlusTransaction($transaction->type) == false
                                    ]); ?>"><?php echo e(isPlusTransaction($transaction->type) == true ? '+' : '-'); ?><?php echo e($transaction->amount.' '.$currency); ?></div>
                                </div>
                                <div class="site-table-col">
                                    <div class="fw-bold red-color">-<?php echo e($transaction->charge.' '.$currency); ?></div>
                                </div>
                                <div class="site-table-col">
                                    <?php if($transaction->status->value == 'failed'): ?>
                                        <div class="type site-badge badge-failed"><?php echo e($transaction->status->value); ?></div>
                                    <?php elseif($transaction->status->value == 'success'): ?>
                                        <div class="type site-badge badge-success"><?php echo e($transaction->status->value); ?></div>
                                    <?php elseif($transaction->status->value == 'pending'): ?>
                                        <div class="type site-badge badge-pending"><?php echo e($transaction->status->value); ?></div>
                                    <?php endif; ?>
                                </div>
                                <div class="site-table-col">
                                    <div class="fw-bold"><?php echo e($transaction->method !== '' ? ucfirst(str_replace('-',' ',$transaction->method)) :  __('System')); ?></div>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <?php if(count($recentTransactions) == 0): ?>
                        <div class="no-data-found"><?php echo e(__('No Data Found')); ?></div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>


<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>

        $('#copy').on('click',function(){
            copyRef();
        });

        function copyRef() {
            /* Get the text field */
            var textToCopy = $('#refLink').val();
            // Create a temporary input element
            var tempInput = $('<input>');
            $('body').append(tempInput);
            tempInput.val(textToCopy).select();
            // Copy the text from the temporary input
            document.execCommand('copy');
            // Remove the temporary input element
            tempInput.remove();

            // Set tooltip as copied
            var tooltip = bootstrap.Tooltip.getInstance('#copy');
            tooltip.setContent({ '.tooltip-inner': 'Copied' });

            setTimeout(() => {
                tooltip.setContent({ '.tooltip-inner': 'Copy' });
            }, 4000);
        }

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend::layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/oyxmpnpf/paysmart.azonetech.com.ng/app/Providers/../../resources/views/frontend/default/user/dashboard.blade.php ENDPATH**/ ?>