<?php if(request('tab') == 'paybacks'): ?>
<div
    class="<?php echo \Illuminate\Support\Arr::toCssClasses([
        'tab-pane fade',
        'show active' => request('tab') == 'paybacks'
    ]); ?>"
    id="pills-deposit"
    role="tabpanel"
    aria-labelledby="pills-deposit-tab"
>
    <div class="row">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
            <div class="site-card">
                <div class="site-card-header">
                    <h4 class="title"><?php echo e(__('Paybacks')); ?></h4>
                    <div
                        class="card-header-info"><?php echo e(__('Total Payback:')); ?> <?php echo e($user->totalProfit()); ?> <?php echo e($currency); ?></div>
                </div>
                <div class="site-card-body table-responsive">

                    <div class="site-table">
                        <div class="table-filter">
                            <form action="" method="get">
                                <input type="hidden" name="tab" value="paybacks">
                                <div class="filter d-flex">
                                    <div class="search">
                                        <label for=""><?php echo e(__('Search:')); ?></label>
                                        <input type="text" name="query" value="<?php echo e(request('query')); ?>"/>
                                    </div>
                                    <button class="apply-btn" type="submit"><i data-lucide="search"></i><?php echo e(__('Search')); ?></button>
                                </div>
                            </form>
                        </div>
                        <table class="table">
                            <thead>
                            <tr>
                                <?php echo $__env->make('backend.filter.th',['label' => 'Date','field' => 'created_at'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php echo $__env->make('backend.filter.th',['label' => 'Amount','field' => 'final_amount'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php echo $__env->make('backend.filter.th',['label' => 'Type','field' => 'type'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php echo $__env->make('backend.filter.th',['label' => 'Payback From','field' => 'profit_from'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php echo $__env->make('backend.filter.th',['label' => 'Description','field' => 'description'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $earnings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $earn): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($earn->created_at); ?></td>
                                    <td>
                                        <?php echo $__env->make('backend.transaction.include.__txn_amount_ajax',['amount' => $earn->final_amount,'type' => $earn->type], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </td>
                                    <td>
                                        <?php echo $__env->make('backend.transaction.include.__txn_type_ajax',[ 'type' => $earn->type->value], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </td>
                                    <td>
                                        <?php echo $__env->make('backend.transaction.include.__user_ajax',['user' => $earn->profit_from_user], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </td>
                                    <td><?php echo e($earn->description); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <td colspan="7" class="text-center"><?php echo e(__('No Data Found!')); ?></td>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>
<?php /**PATH /home/oyxmpnpf/paysmart.azonetech.com.ng/resources/views/backend/user/include/__earnings.blade.php ENDPATH**/ ?>