
<?php $__env->startSection('title'); ?>
    <?php echo e(__('Application Details')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="main-content">
        <div class="page-title">
            <div class="container-fluid">
                <div class="row">
                    <div class="col">
                        <div class="title-content">
                            <h2 class="title"><?php echo e(__('Application Details')); ?></h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">

                <div class="col-xl-12">
                    <div class="site-card">
                        <div class="site-card-header">
                            <h4 class="title"><?php echo e(__('Server Info')); ?></h4>
                        </div>
                        <div class="site-card-body p-0">
                            <div class="site-table table-responsive mb-0">
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th><?php echo e(__('Name')); ?></th>
                                            <th><?php echo e(__('Required Version')); ?></th>
                                            <th><?php echo e(__('Current Version')); ?></th>
                                            <th><?php echo e(__('Status')); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td><strong><?php echo e(__('php Version')); ?></strong></td>
                                            <td>8.1+</td>
                                            <td><?php echo e(substr(PHP_VERSION,0,3)); ?></td>
                                            <td><?php echo substr(PHP_VERSION,0,3) >= 8.1 ? $success : $error; ?> </td>
                                        </tr>
                                        <tr>
                                            <td><strong><?php echo e(__('Laravel Version')); ?></strong></td>
                                            <td>---</td>
                                            <td><?php echo e(app()->version()); ?></td>
                                            <td><?php echo $success; ?> </td>
                                        </tr>
                                        <tr>
                                            <td><strong><?php echo e(__('MySQL Version')); ?></strong></td>
                                            <td>5.7+</td>
                                            <td><?php echo e(substr($mySqlVersion,0,3)); ?></td>
                                            <td><?php echo substr($mySqlVersion,0,3) >= 5.7 ? $success : $error; ?> </td>
                                        </tr>
                                        <tr>
                                            <td><strong><?php echo e(__('DigiBank Version')); ?></strong></td>
                                            <td>---</td>
                                            <td><?php echo e(config('app.version')); ?></td>
                                            <td><?php echo $success; ?> </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="site-card">
                        <div class="site-card-header">
                            <h4 class="title"><?php echo e(__('php.ini Info')); ?></h4>
                        </div>
                        <div class="site-card-body p-0">
                            <div class="site-table table-responsive mb-0">
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th><?php echo e(__('Config Name')); ?></th>
                                            <th><?php echo e(__('Recommended Value')); ?></th>
                                            <th><?php echo e(__('Current Value')); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>file_uploads</td>
                                            <td>
                                                <strong class="site-badge primary">On</strong>
                                            </td>
                                            <td>
                                                <?php if(ini_get('file_uploads') == 1): ?>
                                                <strong class="site-badge primary">On</strong>
                                                <?php else: ?>
                                                <strong class="site-badge danger">Off</strong>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>max_file_uploads</td>
                                            <td>
                                                <strong>10+</strong>
                                            </td>
                                            <td>
                                                <strong><?php echo e(ini_get('max_file_uploads')); ?></strong>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>upload_max_filesize</td>
                                            <td>
                                                <strong>128M+</strong>
                                            </td>
                                            <td>
                                                <strong><?php echo e(ini_get('upload_max_filesize')); ?></strong>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>max_execution_time</td>
                                            <td>
                                                <strong>256+</strong>
                                            </td>
                                            <td>
                                                <strong><?php echo e(ini_get('max_execution_time') == '-1' ? 'Unlimited' : ini_get('max_execution_time')); ?></strong>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>memory_limit</td>
                                            <td>
                                                <strong>128M+</strong>
                                            </td>
                                            <td>
                                                <strong><?php echo e(ini_get('memory_limit') == '-1' ? 'Unlimited' : ini_get('memory_limit')); ?></strong>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="site-card">
                        <div class="site-card-header">
                            <h4 class="title"><?php echo e(__('PHP Extensions Info')); ?></h4>
                        </div>
                        <div class="site-card-body p-0">
                            <div class="site-table table-responsive mb-0">
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th><?php echo e(__('Extension Name')); ?></th>
                                            <th><?php echo e(__('Status')); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $required_extensions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $extension): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><strong><?php echo e($extension); ?></strong></td>
                                            <td><?php echo in_array($extension,get_loaded_extensions()) ? $success : $error; ?> </td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/oyxmpnpf/paysmart.azonetech.com.ng/resources/views/backend/system/index.blade.php ENDPATH**/ ?>