<div class="side-nav">
    <div class="side-nav-inside">
        <ul class="side-nav-menu">

            <li class="side-nav-item <?php echo e(isActive('admin.dashboard')); ?>">
                <a href="<?php echo e(route('admin.dashboard')); ?>"><i data-lucide="layout-dashboard"></i><span><?php echo e(__('Dashboard')); ?></span></a>
            </li>

            
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['customer-list','customer-login','customer-mail-send','customer-basic-manage','customer-balance-add-or-subtract','customer-change-password','all-type-status'])): ?>
            <li class="side-nav-item category-title">
                <span><?php echo e(__('Customer Management')); ?></span>
            </li>
            <li class="side-nav-item side-nav-dropdown <?php echo e(isActive(['admin.user*','admin.notification*'])); ?>">
                <a href="javascript:void(0);" class="dropdown-link">
                    <i data-lucide="users"></i><span><?php echo e(__('Customers')); ?></span>
                    <span class="right-arrow"><i data-lucide="chevron-down"></i></span></a>
                <ul class="dropdown-items">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['customer-list','customer-login','customer-mail-send','customer-basic-manage','customer-balance-add-or-subtract','customer-change-password','all-type-status'])): ?>
                    <li class="<?php echo e(isActive('admin.user.index')); ?>">
                        <a href="<?php echo e(route('admin.user.index')); ?>"><i data-lucide="users"></i><?php echo e(__('All Customers')); ?></a>
                    </li>
                    <li class="<?php echo e(isActive('admin.user.active')); ?>">
                        <a href="<?php echo e(route('admin.user.active')); ?>"><i data-lucide="user-check"></i><?php echo e(__('Active
                            Customers')); ?></a>
                    </li>
                    <li class="<?php echo e(isActive('admin.user.closed')); ?>">
                        <a href="<?php echo e(route('admin.user.closed')); ?>"><i data-lucide="x-circle"></i><?php echo e(__('Closed
                            Customers')); ?></a>
                    </li>
                    <li class="<?php echo e(isActive('admin.user.disabled')); ?>">
                        <a href="<?php echo e(route('admin.user.disabled')); ?>"><i data-lucide="user-x"></i><?php echo e(__('Disabled
                            Customers')); ?></a>
                    </li>
                    <li class="<?php echo e(isActive('admin.user.new')); ?>">
                        <a href="<?php echo e(route('admin.user.new')); ?>"><i data-lucide="user-plus"></i><?php echo e(__('Add New Customer')); ?></a>
                    </li>
                    <?php endif; ?>

                    <li class="<?php echo e(isActive('admin.notification.all')); ?>">
                        <a href="<?php echo e(route('admin.notification.all')); ?>"><i data-lucide="megaphone"></i><?php echo e(__('Notifications')); ?></a>
                    </li>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('customer-mail-send')): ?>
                    <li class="<?php echo e(isActive('admin.user.mail-send.all')); ?>">
                        <a href="<?php echo e(route('admin.user.mail-send.all')); ?>"><i data-lucide="send"></i><?php echo e(__('Send Email to
                            all')); ?></a>
                    </li>
                    <?php endif; ?>

                </ul>
            </li>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['kyc-list','kyc-action','kyc-form-manage'])): ?>
            <li class="side-nav-item side-nav-dropdown <?php echo e(isActive(['admin.kyc*'])); ?>">
                <a href="javascript:void(0);" class="dropdown-link"><i data-lucide="check-square"></i><span><?php echo e(__('KYC Management')); ?></span><span class="right-arrow"><i data-lucide="chevron-down"></i></span></a>
                <ul class="dropdown-items">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['kyc-list','kyc-action'])): ?>
                    <li class="<?php echo e(isActive('admin.kyc.pending')); ?>">
                        <a href="<?php echo e(route('admin.kyc.pending')); ?>"><i data-lucide="airplay"></i><?php echo e(__('Pending KYC')); ?></a>
                    </li>
                    <li class="<?php echo e(isActive('admin.kyc.rejected')); ?>">
                        <a href="<?php echo e(route('admin.kyc.rejected')); ?>"><i data-lucide="file-warning"></i><?php echo e(__('Rejected
                            KYC')); ?></a>
                    </li>
                    <li class="<?php echo e(isActive('admin.kyc.all')); ?>">
                        <a href="<?php echo e(route('admin.kyc.all')); ?>"><i data-lucide="contact"></i><?php echo e(__('All KYC Logs')); ?></a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('kyc-form-manage')): ?>
                    <li class="<?php echo e(isActive('admin.kyc-form*')); ?>">
                        <a href="<?php echo e(route('admin.kyc-form.index')); ?>"><i data-lucide="check-square"></i><?php echo e(__('KYC Options')); ?></a>
                    </li>
                    <?php endif; ?>
                </ul>
            </li>
            <?php endif; ?>

            
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['role-list','role-create','role-edit','staff-list','staff-create','staff-edit'])): ?>
            <li class="side-nav-item category-title">
                <span><?php echo e(__('Access Management')); ?></span>
            </li>
            <li class="side-nav-item side-nav-dropdown <?php echo e(isActive(['admin.roles*','admin.staff*'])); ?>">
                <a href="javascript:void(0);" class="dropdown-link"><i data-lucide="users"></i><span><?php echo e(__('System Access')); ?></span>
                    <span class="right-arrow"><i data-lucide="chevron-down"></i></span></a>
                <ul class="dropdown-items">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['role-list','role-create','role-edit'])): ?>
                    <li class="<?php echo e(isActive('admin.roles*')); ?>">
                        <a href="<?php echo e(route('admin.roles.index')); ?>"><i data-lucide="contact"></i><span><?php echo e(__('Manage Roles')); ?></span></a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['staff-list','staff-create','staff-edit'])): ?>
                    <li class="<?php echo e(isActive('admin.staff*')); ?>">
                        <a href="<?php echo e(route('admin.staff.index')); ?>"><i data-lucide="user-cog"></i><span><?php echo e(__('Manage Staffs')); ?></span></a>
                    </li>
                    <?php endif; ?>
                </ul>
            </li>
            <?php endif; ?>

            <?php if(setting('multi_branch')): ?>
                
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['branch-list','branch-create','branch-edit','branch-staff-list','branch-staff-create','branch-staff-edit'])): ?>
                <li class="side-nav-item category-title">
                    <span><?php echo e(__('Manage Bank Branches')); ?></span>
                </li>
                <li class="side-nav-item side-nav-dropdown <?php echo e(isActive(['admin.branch*','admin.branch-staff*'])); ?>">
                    <a href="javascript:void(0);" class="dropdown-link"><i data-lucide="split"></i><span><?php echo e(__('Manage
                            Branches')); ?></span>
                        <span class="right-arrow"><i data-lucide="chevron-down"></i></span></a>
                    <ul class="dropdown-items">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['branch-list','branch-create','branch-edit'])): ?>
                        <li class="side-nav-item <?php echo e(isActive('admin.branch*')); ?>">
                            <a href="<?php echo e(route('admin.branch.index')); ?>"><i data-lucide="landmark"></i><span><?php echo e(__('All Branch')); ?></span></a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check(['branch-staff-list','branch-staff-create','branch-staff-edit'])): ?>
                        <li class="side-nav-item <?php echo e(isActive('admin.branch-staff*')); ?>">
                            <a href="<?php echo e(route('admin.branch-staff.index')); ?>"><i data-lucide="user-cog"></i><span><?php echo e(__('Branch
                                    Staff')); ?></span></a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </li>
                <?php endif; ?>
            <?php endif; ?>

            
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['transaction-list','user-paybacks-list','bank-profit'])): ?>
            <li class="side-nav-item category-title">
                <span><?php echo e(__('Transactions')); ?></span>
            </li>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('transaction-list')): ?>
            <li class="side-nav-item <?php echo e(isActive('admin.transactions')); ?>">
                <a href="<?php echo e(route('admin.transactions')); ?>"><i data-lucide="cast"></i><span><?php echo e(__('Transactions')); ?></span></a>
            </li>
            <?php endif; ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('wallet-list')): ?>
            <li class="side-nav-item <?php echo e(isActive('admin.wallets')); ?>">
                <a href="<?php echo e(route('admin.wallets')); ?>"><i data-lucide="wallet"></i><span><?php echo e(__('Wallets')); ?></span></a>
            </li>
            <?php endif; ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('virtual-card-list')): ?>
            <li class="side-nav-item <?php echo e(isActive('admin.virtual.cards')); ?>">
                <a href="<?php echo e(route('admin.virtual.cards')); ?>"><i data-lucide="credit-card"></i><span><?php echo e(__('Virtual Cards')); ?></span></a>
            </li>
            <?php endif; ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['user-paybacks-list','bank-profit'])): ?>
            <li class="side-nav-item side-nav-dropdown <?php echo e(isActive(['admin.paybacks', 'admin.bank.profit'])); ?>">
                <a href="javascript:void(0);" class="dropdown-link"><i data-lucide="dollar-sign"></i>
                    <span> <?php echo e(__('Profits')); ?></span>
                    <span class="right-arrow"><i data-lucide="chevron-down"></i></span>
                </a>
                <ul class="dropdown-items">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user-paybacks-list')): ?>
                    <li class="<?php echo e(isActive('admin.paybacks')); ?>">
                        <a href="<?php echo e(route('admin.paybacks')); ?>"><i data-lucide="credit-card"></i><span><?php echo e(__('User Paybacks')); ?></span></a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('bank-profit')): ?>
                    <li class="<?php echo e(isActive('admin.bank.profit')); ?>">
                        <a href="<?php echo e(route('admin.bank.profit')); ?>">
                            <i data-lucide="activity"></i><span><?php echo e(__('Bank Profits')); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>
                </ul>
            </li>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['pending-transfers','rejected-transfers','all-transfers','allied-transfers','others-bank-transfers',
            'wire-transfer','others-bank-list'])): ?>
            <li class="side-nav-item side-nav-dropdown <?php echo e(isActive(['admin.others-bank*', 'admin.wire.transfer*', 'admin.fund.transfer*'])); ?>">
                <a href="javascript:void(0);" class="dropdown-link"><i data-lucide="send"></i><span><?php echo e(__('Fund Transfer')); ?></span>
                    <span class="right-arrow"><i data-lucide="chevron-down"></i></span></a>
                <ul class="dropdown-items">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('pending-transfers')): ?>
                    <li class="side-nav-item <?php echo e(isActive('admin.fund.transfer.pending*')); ?>">
                        <a href="<?php echo e(route('admin.fund.transfer.pending')); ?>"><i data-lucide="wallet-2"></i><span><?php echo e(__('Pending Transfers')); ?></span></a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('rejected-transfers')): ?>
                    <li class="side-nav-item <?php echo e(isActive('admin.fund.transfer.rejected*')); ?>">
                        <a href="<?php echo e(route('admin.fund.transfer.rejected')); ?>"><i data-lucide="file-warning"></i><span><?php echo e(__('Rejected Transfers')); ?></span></a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('all-transfers')): ?>
                    <li class="side-nav-item <?php echo e(isActive('admin.fund.transfer.all*')); ?>">
                        <a href="<?php echo e(route('admin.fund.transfer.all')); ?>"><i data-lucide="contact"></i><span><?php echo e(__('All Transfers')); ?></span></a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('allied-transfers')): ?>
                    <li class="side-nav-item <?php echo e(isActive('admin.fund.transfer.own.bank*')); ?>">
                        <a href="<?php echo e(route('admin.fund.transfer.own.bank')); ?>"><i data-lucide="user-check"></i><span><?php echo e(__('Own Bank Transfer')); ?></span></a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('others-bank-transfers')): ?>
                    <li class="side-nav-item <?php echo e(isActive('admin.fund.transfer.other*')); ?>">
                        <a href="<?php echo e(route('admin.fund.transfer.other')); ?>"><i data-lucide="user-minus"></i><span><?php echo e(__('Other Bank Transfers')); ?></span></a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('wire-transfer')): ?>
                    <li class="side-nav-item <?php echo e(isActive('admin.fund.transfer.wire*')); ?>">
                        <a href="<?php echo e(route('admin.fund.transfer.wire')); ?>"><i data-lucide="settings-2"></i><span><?php echo e(__('Wire Transfer')); ?></span></a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('others-bank-list')): ?>
                    <li class="side-nav-item <?php echo e(isActive('admin.others-bank*')); ?>">
                        <a href="<?php echo e(route('admin.others-bank.index')); ?>"><i data-lucide="landmark"></i><span><?php echo e(__('Others Bank')); ?></span></a>
                    </li>
                    <?php endif; ?>
                </ul>
            </li>
            <?php endif; ?>

            
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['dps-plan-list', 'dps-plan-create', 'dps-plan-edit', 'ongoing-dps','payable-dps','complete-dps','closed-dps','all-dps'])): ?>
            <li class="side-nav-item side-nav-dropdown <?php echo e(isActive(['admin.dps*','admin.plan.dps*'])); ?>">
                <a href="javascript:void(0);" class="dropdown-link"><i data-lucide="archive"></i><span><?php echo e(__('DPS')); ?></span>
                    <span class="right-arrow"><i data-lucide="chevron-down"></i></span>
                </a>

                <ul class="dropdown-items">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('ongoing-dps')): ?>
                    <li class="side-nav-item <?php echo e(isActive('admin.dps.ongoing*')); ?>">
                        <a href="<?php echo e(route('admin.dps.ongoing')); ?>"><i data-lucide="user-check"></i><span><?php echo e(__('Ongoing DPS')); ?></span></a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('payable-dps')): ?>
                    <li class="side-nav-item <?php echo e(isActive('admin.dps.payable*')); ?>">
                        <a href="<?php echo e(route('admin.dps.payable')); ?>"><i data-lucide="user-check"></i><span><?php echo e(__('Payable DPS')); ?></span></a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('complete-dps')): ?>
                    <li class="side-nav-item <?php echo e(isActive('admin.dps.complete*')); ?>">
                        <a href="<?php echo e(route('admin.dps.complete')); ?>"><i data-lucide="user-check"></i><span><?php echo e(__('Completed DPS')); ?></span></a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('closed-dps')): ?>
                    <li class="side-nav-item <?php echo e(isActive('admin.dps.close*')); ?>">
                        <a href="<?php echo e(route('admin.dps.close')); ?>"><i data-lucide="user-check"></i><span><?php echo e(__('Closed DPS')); ?></span></a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('all-dps')): ?>
                    <li class="side-nav-item <?php echo e(isActive('admin.dps.all*')); ?>">
                        <a href="<?php echo e(route('admin.dps.all')); ?>"><i data-lucide="user-check"></i><span><?php echo e(__('All DPS')); ?></span></a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['dps-plan-list', 'dps-plan-create', 'dps-plan-edit'])): ?>
                    <li class="side-nav-item <?php echo e(isActive('admin.plan.dps*')); ?>">
                        <a href="<?php echo e(route('admin.plan.dps.index')); ?>"><i data-lucide="airplay"></i><span><?php echo e(__('DPS Plans')); ?></span></a>
                    </li>
                    <?php endif; ?>
                </ul>
            </li>
            <?php endif; ?>

            
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['fdr-plan-list', 'fdr-plan-create', 'fdr-plan-edit', 'ongoing-fdr','closed-fdr','completed-fdr','all-fdr'])): ?>
            <li class="side-nav-item side-nav-dropdown <?php echo e(isActive(['admin.fdr*', 'admin.plan.fdr*'])); ?>">
                <a href="javascript:void(0);" class="dropdown-link"><i data-lucide="book"></i><span><?php echo e(__('FDR')); ?></span>
                    <span class="right-arrow"><i data-lucide="chevron-down"></i></span></a>
                <ul class="dropdown-items">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('ongoing-fdr')): ?>
                    <li class="side-nav-item <?php echo e(isActive('admin.fdr.ongoing*')); ?>">
                        <a href="<?php echo e(route('admin.fdr.ongoing')); ?>"><i data-lucide="user-check"></i><span><?php echo e(__('Ongoing FDR')); ?></span></a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('closed-fdr')): ?>
                    <li class="side-nav-item <?php echo e(isActive('admin.fdr.close*')); ?>">
                        <a href="<?php echo e(route('admin.fdr.close')); ?>"><i data-lucide="user-check"></i><span><?php echo e(__('Closed FDR')); ?></span></a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('completed-fdr')): ?>
                    <li class="side-nav-item <?php echo e(isActive('admin.fdr.completed*')); ?>">
                        <a href="<?php echo e(route('admin.fdr.completed')); ?>"><i data-lucide="user-check"></i><span><?php echo e(__('Completed FDR')); ?></span></a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('all-fdr')): ?>
                    <li class="side-nav-item <?php echo e(isActive('admin.fdr.all*')); ?>">
                        <a href="<?php echo e(route('admin.fdr.all')); ?>"><i data-lucide="user-check"></i><span><?php echo e(__('All FDR')); ?></span></a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['fdr-plan-list', 'fdr-plan-create', 'fdr-plan-edit'])): ?>
                    <li class="side-nav-item <?php echo e(isActive('admin.plan.fdr*')); ?>">
                        <a href="<?php echo e(route('admin.plan.fdr.index')); ?>"><i data-lucide="airplay"></i><span><?php echo e(__('FDR Plans')); ?></span></a>
                    </li>
                    <?php endif; ?>
                </ul>
            </li>
            <?php endif; ?>

            
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['pending-loan','running-loan','due-loan','paid-loan','rejected-loan','all-loan','loan-plan-list', 'loan-plan-create', 'loan-plan-edit','loan-plan-delete'])): ?>
            <li class="side-nav-item side-nav-dropdown <?php echo e(isActive(['admin.plan.loan*','admin.loan*'])); ?>">
                <a href="javascript:void(0);" class="dropdown-link"><i data-lucide="alert-triangle"></i><span><?php echo e(__('Loan')); ?></span>
                    <span class="right-arrow"><i data-lucide="chevron-down"></i></span></a>
                <ul class="dropdown-items">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('pending-loan')): ?>
                    <li class="side-nav-item <?php echo e(isActive('admin.loan.request')); ?>">
                        <a href="<?php echo e(route('admin.loan.request')); ?>"><i data-lucide="user-check"></i><span><?php echo e(__('Loan Request')); ?></span></a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('running-loan')): ?>
                    <li class="side-nav-item <?php echo e(isActive('admin.loan.approved*')); ?>">
                        <a href="<?php echo e(route('admin.loan.approved')); ?>"><i data-lucide="user-check"></i><span><?php echo e(__('Approved Loan')); ?></span></a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('due-loan')): ?>
                    <li class="side-nav-item <?php echo e(isActive('admin.loan.payable*')); ?>">
                        <a href="<?php echo e(route('admin.loan.payable')); ?>"><i data-lucide="user-check"></i><span><?php echo e(__('Payable Installment')); ?></span></a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('paid-loan')): ?>
                    <li class="side-nav-item <?php echo e(isActive('admin.loan.completed*')); ?>">
                        <a href="<?php echo e(route('admin.loan.completed')); ?>"><i data-lucide="user-check"></i><span><?php echo e(__('Completed Loan')); ?></span></a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('rejected-loan')): ?>
                    <li class="side-nav-item <?php echo e(isActive('admin.loan.rejected*')); ?>">
                        <a href="<?php echo e(route('admin.loan.rejected')); ?>"><i data-lucide="user-check"></i><span><?php echo e(__('Rejected Loan')); ?></span></a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('all-loan')): ?>
                    <li class="side-nav-item <?php echo e(isActive('admin.loan.all*')); ?>">
                        <a href="<?php echo e(route('admin.loan.all')); ?>"><i data-lucide="user-check"></i><span><?php echo e(__('All Loan')); ?></span></a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['loan-plan-list', 'loan-plan-create', 'loan-plan-edit','loan-plan-delete'])): ?>
                    <li class="side-nav-item <?php echo e(isActive('admin.plan.loan*')); ?>">
                        <a href="<?php echo e(route('admin.plan.loan.index')); ?>"><i data-lucide="airplay"></i><span><?php echo e(__('Loan Plans')); ?></span></a>
                    </li>
                    <?php endif; ?>
                </ul>
            </li>
            <?php endif; ?>
            <?php endif; ?>


            

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['bill-service-import', 'bill-convert-rate', 'bill-service-list','all-bills', 'pending-bills', 'complete-bills', 'return-bills'])): ?>
                <li class="side-nav-item category-title">
                    <span><?php echo e(__('Bill Management')); ?></span>
                </li>

                <li class="side-nav-item side-nav-dropdown <?php echo e(isActive(['admin.bill.import.services','admin.bill.convert.rate','admin.bill.service*'])); ?>">
                    <a href="javascript:void(0);" class="dropdown-link"><i data-lucide="file"></i>
                        <span><?php echo e(__('Bill Management')); ?></span>
                        <span class="right-arrow"><i data-lucide="chevron-down"></i></span>
                    </a>
                    <ul class="dropdown-items">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('bill-service-import')): ?>
                            <li class="side-nav-item <?php echo e(isActive('admin.bill.import.services')); ?>">
                                <a href="<?php echo e(route('admin.bill.import.services')); ?>"><i data-lucide="download"></i><span><?php echo e(__('Import Services')); ?></span></a>
                            </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('bill-convert-rate')): ?>
                            <li class="side-nav-item <?php echo e(isActive('admin.bill.convert.rate')); ?>">
                                <a href="<?php echo e(route('admin.bill.convert.rate')); ?>"><i data-lucide="git-pull-request"></i><span><?php echo e(__('Convert Rate')); ?></span></a>
                            </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('bill-service-list')): ?>
                            <li class="side-nav-item <?php echo e(isActive('admin.bill.service*')); ?>">
                                <a href="<?php echo e(route('admin.bill.service.index')); ?>"><i data-lucide="list"></i><span><?php echo e(__('Bill Service List')); ?></span></a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </li>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['all-bills', 'pending-bills', 'complete-bills', 'return-bills'])): ?>
                    <li class="side-nav-item side-nav-dropdown <?php echo e(isActive(['admin.bill.history*'])); ?>">
                        <a href="javascript:void(0);" class="dropdown-link"><i data-lucide="arrow-down-circle"></i><span><?php echo e(__('Bill History')); ?></span><span class="right-arrow"><i data-lucide="chevron-down"></i></span></a>
                        <ul class="dropdown-items">

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('pending-bills')): ?>
                            <li class="<?php echo e(isActive('admin.bill.history.pending')); ?>"><a
                                    href="<?php echo e(route('admin.bill.history.pending')); ?>"><i data-lucide="workflow"></i><?php echo e(__('Pending Bill')); ?></a></li>
                            <?php endif; ?>

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('complete-bills')): ?>
                            <li class="<?php echo e(isActive('admin.bill.history.complete')); ?>"><a
                                    href="<?php echo e(route('admin.bill.history.complete')); ?>"><i data-lucide="compass"></i><?php echo e(__('Complete Bill')); ?></a></li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('return-bills')): ?>
                            <li class="<?php echo e(isActive('admin.bill.history.returned')); ?>"><a
                                    href="<?php echo e(route('admin.bill.history.returned')); ?>"><i data-lucide="compass"></i><?php echo e(__('Returned Bill')); ?></a></li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('all-bills')): ?>
                            <li class="<?php echo e(isActive('admin.bill.history.all')); ?>"><a href="<?php echo e(route('admin.bill.history.all')); ?>"><i
                                        data-lucide="compass"></i><?php echo e(__('All Bill')); ?></a></li>
                            <?php endif; ?>
                        </ul>
                    </li>
                <?php endif; ?>

            <?php endif; ?>


            
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['automatic-gateway-manage','manual-gateway-manage','deposit-list','deposit-action',
            'withdraw-list','withdraw-method-manage','withdraw-action','referral-create',
            'manage-referral','referral-edit','referral-delete','manage-portfolio','portfolio-edit','portfolio-create','reward-earning-list','reward-earning-create','reward-earning-edit','reward-earning-delete','reward-redeem-list','reward-redeem-create','reward-redeem-edit','reward-redeem-delete'])): ?>

            <li class="side-nav-item category-title">
                <span><?php echo e(__('Essentials')); ?></span>
            </li>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['automatic-gateway-manage','manual-gateway-manage','deposit-list','deposit-action'])): ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('automatic-gateway-manage')): ?>
            <li class="side-nav-item <?php echo e(isActive('admin.gateway*')); ?>">
                <a href="<?php echo e(route('admin.gateway.automatic')); ?>"><i data-lucide="door-open"></i><span><?php echo e(__('Automatic
                        Gateways')); ?></span></a>
            </li>
            <?php endif; ?>

            <li class="side-nav-item side-nav-dropdown <?php echo e(isActive(['admin.deposit*'])); ?>">
                <a href="javascript:void(0);" class="dropdown-link"><i data-lucide="arrow-down-circle"></i><span><?php echo e(__('Deposits')); ?></span><span class="right-arrow"><i data-lucide="chevron-down"></i></span></a>
                <ul class="dropdown-items">

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('automatic-gateway-manage')): ?>
                    <li class="<?php echo e(isActive('admin.deposit.method.list','auto')); ?>"><a
                            href="<?php echo e(route('admin.deposit.method.list','auto')); ?>"><i data-lucide="workflow"></i><?php echo e(__('Automatic Methods')); ?></a></li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manual-gateway-manage')): ?>
                    <li class="<?php echo e(isActive('admin.deposit.method.list','manual')); ?>"><a
                            href="<?php echo e(route('admin.deposit.method.list','manual')); ?>"><i data-lucide="compass"></i><?php echo e(__('Manual Methods')); ?></a></li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['deposit-list','deposit-action'])): ?>
                    <li class="<?php echo e(isActive('admin.deposit.manual.pending')); ?>"><a
                            href="<?php echo e(route('admin.deposit.manual.pending')); ?>"><i data-lucide="columns"></i><?php echo e(__('Pending
                            Manual Deposits')); ?></a></li>
                    <li class="<?php echo e(isActive('admin.deposit.history')); ?>"><a
                            href="<?php echo e(route('admin.deposit.history')); ?>"><i data-lucide="clipboard-check"></i><?php echo e(__('Deposit History')); ?></a></li>
                    <?php endif; ?>
                </ul>
            </li>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['withdraw-list','withdraw-method-manage','withdraw-action','withdraw-schedule'])): ?>
            <li class="side-nav-item side-nav-dropdown  <?php echo e(isActive(['admin.withdraw*'])); ?>">
                <a href="javascript:void(0);" class="dropdown-link"><i data-lucide="landmark"></i><span><?php echo e(__('Withdraw')); ?></span><span class="right-arrow"><i data-lucide="chevron-down"></i></span></a>
                <ul class="dropdown-items">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('withdraw-method-manage')): ?>
                    <li class="<?php echo e(isActive('admin.withdraw.method.list','auto')); ?>">
                        <a href="<?php echo e(route('admin.withdraw.method.list','auto')); ?>"><i data-lucide="workflow"></i><?php echo e(__('Automatic Methods')); ?></a>
                    </li>
                    <li class="<?php echo e(isActive('admin.withdraw.method.list','manual')); ?>">
                        <a href="<?php echo e(route('admin.withdraw.method.list','manual')); ?>"><i data-lucide="compass"></i><?php echo e(__('Manual Methods')); ?></a>
                    </li>

                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['withdraw-list','withdraw-action'])): ?>
                    <li class="<?php echo e(isActive('admin.withdraw.pending')); ?>"><a
                            href="<?php echo e(route('admin.withdraw.pending')); ?>"><i data-lucide="wallet"></i><?php echo e(__('Pending
                            Withdraws')); ?></a></li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('withdraw-schedule')): ?>
                    <li class="<?php echo e(isActive('admin.withdraw.schedule')); ?>"><a
                            href="<?php echo e(route('admin.withdraw.schedule')); ?>"><i data-lucide="alarm-clock"></i><?php echo e(__('Withdraw
                            Schedule')); ?></a></li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('withdraw-list')): ?>
                    <li class="<?php echo e(isActive('admin.withdraw.history')); ?>"><a
                            href="<?php echo e(route('admin.withdraw.history')); ?>"><i data-lucide="piggy-bank"></i><?php echo e(__('Withdraw
                            History')); ?></a></li>
                    <?php endif; ?>
                </ul>
            </li>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['referral-create','manage-referral','referral-edit','referral-delete'])): ?>
            <li class="side-nav-item <?php echo e(isActive('admin.referral.*')); ?>">
                <a href="<?php echo e(route('admin.referral.index')); ?>"><i data-lucide="align-end-horizontal"></i><span><?php echo e(__('Referral')); ?></span></a>
            </li>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['manage-portfolio','portfolio-create','portfolio-edit'])): ?>
            <li class="side-nav-item <?php echo e(isActive('admin.portfolio.*')); ?>">
                <a href="<?php echo e(route('admin.portfolio.index')); ?>"><i data-lucide="medal"></i><span><?php echo e(__('Portfolios')); ?></span></a>
            </li>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['reward-earning-list','reward-earning-create','reward-earning-edit','reward-earning-delete','reward-redeem-list','reward-redeem-create','reward-redeem-edit','reward-redeem-delete'])): ?>
            <li class="side-nav-item side-nav-dropdown <?php echo e(isActive(['admin.reward.point*'])); ?>">
                <a href="javascript:void(0);" class="dropdown-link">
                    <i data-lucide="medal"></i>
                    <span><?php echo e(__('Manage Reward Point')); ?></span>
                    <span class="right-arrow"><i data-lucide="chevron-down"></i></span>
                </a>

                <ul class="dropdown-items">

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['reward-earning-list','reward-earning-create','reward-earning-edit','reward-earning-delete'])): ?>
                    <li class="<?php echo e(isActive('admin.reward.point.earnings*')); ?>">
                        <a href="<?php echo e(route('admin.reward.point.earnings.index')); ?>">
                            <i data-lucide="align-end-horizontal"></i><?php echo e(__('Reward Earnings')); ?>

                        </a>
                    </li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['reward-redeem-list','reward-redeem-create','reward-redeem-edit','reward-redeem-delete'])): ?>
                    <li class="<?php echo e(isActive('admin.reward.point.redeem*')); ?>">
                        <a href="<?php echo e(route('admin.reward.point.redeem.index')); ?>">
                            <i data-lucide="align-end-horizontal"></i><?php echo e(__('Reward Redeems')); ?>

                        </a>
                    </li>
                    <?php endif; ?>
                </ul>
            </li>
            <?php endif; ?>

            <?php endif; ?>

            
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['site-setting','email-setting','plugin-setting','page-manage','language-setting','sms-setting','push-notification-setting','notification-tune-setting'])): ?>
            <li class="side-nav-item category-title">
                <span><?php echo e(__('Site Settings')); ?></span>
            </li>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['site-setting','email-setting','plugin-setting','page-manage','language-setting','sms-setting','push-notification-setting','notification-tune-setting'])): ?>
            <li class="side-nav-item side-nav-dropdown <?php echo e(isActive(['admin.settings*','admin.language*','admin.page.setting'])); ?>">
                <a href="javascript:void(0);" class="dropdown-link"><i data-lucide="settings"></i>
                    <span><?php echo e(__('Settings')); ?></span><span class="right-arrow"><i data-lucide="chevron-down"></i></span></a>
                <ul class="dropdown-items">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('site-setting')): ?>
                    <li class="<?php echo e(isActive('admin.settings.site')); ?>">
                        <a href="<?php echo e(route('admin.settings.site')); ?>"><i data-lucide="settings-2"></i><?php echo e(__('Site Settings')); ?></a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('email-setting')): ?>
                    <li class="<?php echo e(isActive('admin.settings.mail')); ?>">
                        <a href="<?php echo e(route('admin.settings.mail')); ?>"><i data-lucide="inbox"></i><?php echo e(__('Email Settings')); ?></a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('site-setting')): ?>
                    <li class="<?php echo e(isActive('admin.settings.seo.meta')); ?>">
                        <a href="<?php echo e(route('admin.settings.seo.meta')); ?>"><i data-lucide="search-code"></i><?php echo e(__('SEO Meta Settings')); ?></a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('language-setting')): ?>
                    <li class="<?php echo e(isActive('admin.language*')); ?>">
                        <a href="<?php echo e(route('admin.language.index')); ?>"><i data-lucide="languages"></i><span><?php echo e(__('Language Settings')); ?></span></a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('page-manage')): ?>
                    <li class="side-nav-item <?php echo e(isActive('admin.page.setting')); ?>">
                        <a href="<?php echo e(route('admin.page.setting')); ?>"><i data-lucide="layout"></i><span><?php echo e(__('Page Settings')); ?></span></a>
                    </li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('plugin-setting')): ?>
                    <li class="<?php echo e(isActive('admin.settings.plugin','system')); ?>">
                        <a href="<?php echo e(route('admin.settings.plugin','system')); ?>"><i data-lucide="toy-brick"></i><?php echo e(__('Plugin Settings')); ?></a>
                    </li>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('sms-setting')): ?>
                    <li class="<?php echo e(isActive('admin.settings.plugin','sms')); ?>">
                        <a href="<?php echo e(route('admin.settings.plugin','sms')); ?>"><i data-lucide="message-circle"></i><?php echo e(__('SMS Settings')); ?></a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('push-notification-setting')): ?>
                    <li class="<?php echo e(isActive('admin.settings.plugin','notification')); ?>">
                        <a href="<?php echo e(route('admin.settings.plugin','notification')); ?>"><i data-lucide="bell-ring"></i><?php echo e(__('Push Notification')); ?></a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('notification-tune-setting')): ?>
                    <li class="<?php echo e(isActive('admin.settings.notification.tune')); ?>">
                        <a href="<?php echo e(route('admin.settings.notification.tune')); ?>"><i data-lucide="volume-2"></i><?php echo e(__('Notification Tune')); ?></a>
                    </li>
                    <?php endif; ?>
                    <?php endif; ?>

                </ul>
            </li>
            <?php endif; ?>
            <?php endif; ?>


            
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['landing-page-manage','page-manage','footer-manage','navigation-manage','custom-css'])): ?>
            <li class="side-nav-item category-title">
                <span><?php echo e(__('Appearance & Pages')); ?></span>
            </li>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('landing-page-manage')): ?>
            
            <li class="side-nav-item side-nav-dropdown  <?php echo e(isActive(['admin.theme*','admin.custom-css'])); ?>">
                <a href="javascript:void(0);" class="dropdown-link"><i data-lucide="palette"></i><span><?php echo e(__('Appearance')); ?></span><span class="right-arrow"><i data-lucide="chevron-down"></i></span></a>
                <ul class="dropdown-items">
                    <li class="<?php echo e(isActive('admin.theme.site')); ?>">
                        <a href="<?php echo e(route('admin.theme.site')); ?>"><i data-lucide="roller-coaster"></i><?php echo e(__('Site Theme')); ?></a>
                    </li>
                    <li class="<?php echo e(isActive('admin.theme.dynamic-landing')); ?>">
                        <a href="<?php echo e(route('admin.theme.dynamic-landing')); ?>"><i data-lucide="warehouse"></i><?php echo e(__('Dynamic
                            Landing Theme')); ?></a>
                    </li>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('custom-css')): ?>
                    <li class="side-nav-item <?php echo e(isActive('admin.custom-css')); ?>">
                        <a href="<?php echo e(route('admin.custom-css')); ?>"><i data-lucide="braces"></i><span><?php echo e(__('Custom CSS')); ?></span></a>
                    </li>
                    <?php endif; ?>
                </ul>
            </li>
            

            <li class="side-nav-item side-nav-dropdown  <?php echo e(isActive(['admin.page.section.section*','admin.footer-content'])); ?>">
                <a href="javascript:void(0);" class="dropdown-link"><i data-lucide="home"></i><span><?php echo e(__('Landing Page')); ?></span><span class="right-arrow"><i data-lucide="chevron-down"></i></span></a>
                <ul class="dropdown-items">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('page-manage')): ?>
                    <li class="side-nav-item <?php echo e(isActive('admin.page.section.management*')); ?>">
                        <a href="<?php echo e(route('admin.page.section.management')); ?>"><i data-lucide="list-end"></i><span><?php echo e(__('Section Management')); ?></span></a>
                    </li>
                    <?php endif; ?>
                    <?php $__currentLoopData = $landingSections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li class="<?php if(request()->is('admin/page/section/'.$section->code)): ?> active <?php endif; ?>">
                        <a href="<?php echo e(route('admin.page.section.section',$section->code)); ?>"><i data-lucide="egg"></i><?php echo e($section->name); ?></a>
                    </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('footer-manage')): ?>
                    <li class="side-nav-item <?php echo e(isActive('admin.footer-content')); ?>">
                        <a href="<?php echo e(route('admin.footer-content')); ?>"><i data-lucide="list-end"></i><span><?php echo e(__('Footer Contents')); ?></span></a>
                    </li>
                    <?php endif; ?>
                </ul>
            </li>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('page-manage')): ?>
            <li class="side-nav-item side-nav-dropdown <?php echo e(isActive(['admin.page.edit*','admin.page.create'])); ?>">
                <a href="javascript:void(0);" class="dropdown-link"><i data-lucide="layout-grid"></i><span><?php echo e(__('Pages')); ?></span><span class="right-arrow"><i data-lucide="chevron-down"></i></span></a>
                <ul class="dropdown-items">
                    <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li class="<?php if(request()->is('admin/page/edit/'.$page->code)): ?> active <?php endif; ?>">
                        <a href="<?php echo e(route('admin.page.edit',$page->code)); ?>"><i data-lucide="egg"></i><?php echo e($page->title); ?></a>
                    </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <li class="<?php echo e(isActive('admin.page.create')); ?>">
                        <a href="<?php echo e(route('admin.page.create')); ?>"><i data-lucide="egg"></i><?php echo e(__('Add New Page')); ?></a>
                    </li>
                </ul>
            </li>
            <?php endif; ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('navigation-manage')): ?>
            <li class="side-nav-item <?php echo e(isActive('admin.navigation*')); ?>">
                <a href="<?php echo e(route('admin.navigation.menu')); ?>"><i data-lucide="menu"></i><span><?php echo e(__('Site Navigations')); ?></span></a>
            </li>
            <?php endif; ?>

            <?php endif; ?>

            

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any((['subscriber-list','subscriber-mail-send','support-ticket-list','support-ticket-action','email-template','sms-template','sms-template','push-notification-template']))): ?>
            <li class="side-nav-item category-title">
                <span><?php echo e(__('Support & Newsletter')); ?></span>
            </li>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['sms-template','email-template','push-notification-template'])): ?>
            <li class="side-nav-item side-nav-dropdown <?php echo e(isActive(['admin.email-template','admin.template.*'])); ?>">
                <a href="javascript:void(0);" class="dropdown-link">
                    <i data-lucide="mail"></i><span><?php echo e(__('Templates')); ?></span>
                    <span class="right-arrow"><i data-lucide="chevron-down"></i></span>
                </a>

                <ul class="dropdown-items">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('email-template')): ?>
                    <li class="<?php echo e(isActive('admin.email-template')); ?>">
                        <a href="<?php echo e(route('admin.email-template')); ?>"><i data-lucide="mail"></i><span><?php echo e(__('Email Template')); ?></span></a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('sms-template')): ?>
                    <li class="<?php echo e(isActive('admin.template.sms.index')); ?>">
                        <a href="<?php echo e(route('admin.template.sms.index')); ?>"><i data-lucide="message-square"></i><span><?php echo e(__('SMS
                                Template')); ?></span></a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('push-notification-template')): ?>
                    <li class="<?php echo e(isActive('admin.template.notification.index')); ?>">
                        <a href="<?php echo e(route('admin.template.notification.index')); ?>"><i data-lucide="bell-ring"></i><span><?php echo e(__('Push Notification Template')); ?></span></a>
                    </li>
                    <?php endif; ?>
                </ul>
            </li>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['subscriber-list','subscriber-mail-send','support-ticket-list','support-ticket-action'])): ?>
            <li class="side-nav-item side-nav-dropdown <?php echo e(isActive(['admin.subscriber','admin.ticket*'])); ?>">
                <a href="javascript:void(0);" class="dropdown-link">
                    <i data-lucide="wrench"></i><span><?php echo e(__('Subscriber & Support')); ?></span>
                    <span class="right-arrow"><i data-lucide="chevron-down"></i></span>
                </a>
                <ul class="dropdown-items">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['subscriber-list','subscriber-mail-send'])): ?>
                    <li class="<?php echo e(isActive('admin.subscriber')); ?>">
                        <a href="<?php echo e(route('admin.subscriber')); ?>"><i data-lucide="mail-open"></i><span><?php echo e(__('All Subscriber')); ?></span></a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['support-ticket-list','support-ticket-action'])): ?>
                    <li class="<?php echo e(isActive('admin.ticket*')); ?>">
                        <a href="<?php echo e(route('admin.ticket.index')); ?>"><i data-lucide="wrench"></i><span><?php echo e(__('Support Tickets')); ?></span></a>
                    </li>
                    <?php endif; ?>
                </ul>
            </li>
            <?php endif; ?>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['manage-cron-job','cron-job-create','cron-job-edit','cron-job-logs','cron-job-run','cron-job-delete','clear-cache','application-details'])): ?>
            <li class="side-nav-item category-title">
                <span><?php echo e(__('System')); ?></span>
            </li>
            <li class="side-nav-item side-nav-dropdown <?php echo e(isActive(['admin.clear-cache','admin.application-info','admin.cron.jobs.*'])); ?>">
                <a href="javascript:void(0);" class="dropdown-link">
                    <i data-lucide="power"></i><span><?php echo e(__('System')); ?></span>
                    <span class="right-arrow"><i data-lucide="chevron-down"></i></span>
                </a>
                <ul class="dropdown-items">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-cron-job')): ?>
                    <li class="<?php echo e(isActive('admin.cron.jobs.*')); ?>">
                        <a href="<?php echo e(route('admin.cron.jobs.index')); ?>"><i data-lucide="alarm-clock"></i><span><?php echo e(__('Cron Jobs')); ?></span></a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('clear-cache')): ?>
                    <li class="<?php echo e(isActive('admin.clear-cache')); ?>">
                        <a href="<?php echo e(route('admin.clear-cache')); ?>"><i data-lucide="trash-2"></i><span><?php echo e(__('Clear Cache')); ?></span></a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('application-details')): ?>
                    <li class="<?php echo e(isActive('admin.application-info')); ?>">
                        <a href="<?php echo e(route('admin.application-info')); ?>">
                            <i data-lucide="app-window"></i>
                            <span><?php echo e(__('Application Details')); ?></span>
                            <span class="badge yellow-color"><?php echo e(config('app.version')); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>
                </ul>
            </li>
            <?php endif; ?>
        </ul>
    </div>
</div>
<?php /**PATH /home/oyxmpnpf/paysmart.azonetech.com.ng/resources/views/backend/include/__side_nav.blade.php ENDPATH**/ ?>