
<?php $__env->startSection('title'); ?>
    <?php echo e($data['title']); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta_keywords'); ?>
    <?php echo e($data['meta_keywords']); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta_description'); ?>
    <?php echo e($data['meta_description']); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-content'); ?>
<?php
    $redeems = App\Models\RewardPointRedeem::with('portfolio')->get();
    $transactions = App\Models\RewardPointEarning::with('portfolio')->get();
?>

    <!-- Rewards card area start -->
    <section class="rewards-card-area position-relative fix section-space">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-8">
                    <div class="section-title-wrapper text-center section-title-space">
                        <h2 data-aos="fade-up" data-aos-duration="1500" class="section-title"><?php echo e($data['title_one']); ?></h2>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="rewards-card-grid">
                    <?php $__currentLoopData = $redeems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $redeem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="rewards-card-item">
                        <div class="shape-one">
                            <img src="<?php echo e(asset('front/images/shapes/rewards-shape-01.svg')); ?>" alt="">
                        </div>
                        <div class="shape-two">
                            <img src="<?php echo e(asset('front/images/shapes/rewards-shape-02.svg')); ?>" alt="">
                        </div>
                        <div class="content-inner">
                            <div class="content">
                                <h3 class="title"><?php echo e($redeem->portfolio?->portfolio_name); ?></h3>
                            </div>
                            <div class="icon">
                                <span><img src="<?php echo e(asset($redeem->portfolio?->icon)); ?>" alt=""></span>
                            </div>
                        </div>
                        <div class="btn-inner">
                            <a class="site-btn" href="<?php echo e(route('user.rewards.index')); ?>"><?php echo e(__('Redeem Now')); ?></a>
                            <div class="card-point">
                                <span><?php echo e($redeem->point); ?> <?php echo e(__('Points')); ?> = <?php echo e($redeem->amount); ?> <?php echo e($currency); ?></span>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </section>
    <!-- Rewards card area end -->

    <!-- Rewards point area start -->
    <section class="rewards-point-area whiteSmoke-bg position-relative fix section-space">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-8">
                    <div class="section-title-wrapper text-center section-title-space">
                        <h2 data-aos="fade-up" data-aos-duration="1500" class="section-title"><?php echo e($data['title_two']); ?></h2>
                    </div>
                </div>
            </div>
            <div class="row gy-30 justify-content-center" data-aos="fade-up" data-aos-duration="2000">
                <div class="col-lg-6">
                    <div class="rewards-point-item">
                        <div class="reward-table table-responsive">
                           <table class="table">
                              <thead>
                                 <tr>
                                      <th><?php echo e(__('Portfolio List')); ?></th>
                                      <th><?php echo e(__('Per Transactions')); ?></th>
                                      <th><?php echo e(__('Points')); ?></th>
                                 </tr>
                              </thead>
                              <tbody>
                                  <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                  <tr>
                                      <td><?php echo e($item->portfolio->portfolio_name); ?></td>
                                      <td><?php echo e($currencySymbol.$item->amount_of_transactions); ?></td>
                                      <td><?php echo e($item->point); ?> <?php echo e(__('Points')); ?></td>
                                  </tr>
                                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                              </tbody>
                           </table>
                        </div>
                     </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Rewards point area end -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend::pages.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/oyxmpnpf/paysmart.azonetech.com.ng/app/Providers/../../resources/views/frontend/default/pages/rewards.blade.php ENDPATH**/ ?>