<?php if(request('tab') == 'fdr'): ?>
<div
    class="<?php echo \Illuminate\Support\Arr::toCssClasses([
        'tab-pane fade',
        'show active' => request('tab') == 'fdr'
    ]); ?>"
    id="pills-fdr"
    role="tabpanel"
    aria-labelledby="pills-fdr-tab"
>
    <div class="row">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
            <div class="site-card">
                <div class="site-card-header">
                    <h4 class="title"><?php echo e(__('FDR')); ?></h4>
                </div>
                <div class="site-card-body table-responsive">
                    <div class="site-table">
                        <div class="table-filter">
                            <form action="" method="get">
                                <input type="hidden" name="tab" value="fdr">
                                <div class="filter d-flex">
                                    <div class="search">
                                        <label for=""><?php echo e(__('Search:')); ?></label>
                                        <input type="text" name="query" value="<?php echo e(request('query')); ?>"/>
                                    </div>
                                    <button class="apply-btn" type="submit"><i data-lucide="search"></i><?php echo e(__('Search')); ?></button>
                                </div>
                            </form>
                        </div>
                        <table class="table">
                            <thead>
                            <tr>
                                <?php echo $__env->make('backend.filter.th',['label' => 'Date','field' => 'created_at'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php echo $__env->make('backend.filter.th',['label' => 'FDR','field' => 'fdr'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php echo $__env->make('backend.filter.th',['label' => 'FDR ID','field' => 'fdr_id'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php echo $__env->make('backend.filter.th',['label' => 'Amount','field' => 'amount'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <th><?php echo e(__('Profit')); ?></th>
                                <th><?php echo e(__('Next Receive')); ?></th>
                                <th><?php echo e(__('Returns')); ?></th>
                                <th><?php echo e(__('Paid')); ?></th>
                                <?php echo $__env->make('backend.filter.th',['label' => 'Status','field' => 'status'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $fdres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fdr): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($fdr->created_at->format('d M Y h:i A')); ?></td>
                                    <td><?php echo e($fdr->plan?->name); ?></td>
                                    <td><?php echo e($fdr->fdr_id); ?></td>
                                    <td>
                                        <?php echo e($currencySymbol.$fdr->amount); ?>

                                    </td>
                                    <td><?php echo e($currencySymbol.$fdr->profit()); ?></td>
                                    <td>
                                        <?php
                                            $trx = \App\Models\FDRTransaction::where('fdr_id', $fdr->id)->where('paid_amount', null)->first();
                                        ?>
                                        <?php echo e($trx?->given_date?->format('d M Y')); ?>

                                    </td>
                                    <td>
                                        <?php echo e($fdr->totalInstallment()); ?>

                                    </td>
                                    <td>
                                        <?php echo e($currencySymbol.$fdr->transactions->sum('paid_amount')); ?>

                                    </td>

                                    <td>
                                        <?php if($fdr->status->value == 'running'): ?>
                                            <div class="type site-badge primary"><?php echo e(ucfirst($fdr->status->value)); ?></div>
                                        <?php elseif($fdr->status->value == 'closed'): ?>
                                            <div class="type site-badge danger"><?php echo e(ucfirst($fdr->status->value)); ?></div>
                                        <?php elseif($fdr->status->value == 'mature'): ?>
                                            <div class="type site-badge success"><?php echo e(ucfirst($fdr->status->value)); ?></div>
                                        <?php elseif($fdr->status->value == 'due'): ?>
                                            <div class="type site-badge pending"><?php echo e(ucfirst($fdr->status->value)); ?></div>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <td colspan="7" class="text-center"><?php echo e(__('No Data Found')); ?>!</td>
                                <?php endif; ?>
                            </tbody>
                        </table>
                        <?php echo e($fdres->links()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>
<?php /**PATH /home/oyxmpnpf/paysmart.azonetech.com.ng/resources/views/backend/user/include/__fdr.blade.php ENDPATH**/ ?>