<?php
    $landingContent =\App\Models\LandingContent::where('type','faq')->where('locale',app()->getLocale())->get();
?>
<!-- FAQ area start -->
<section class="faq-area fix position-relative section-space include-bg"
    data-background="<?php echo e(asset('/front/images/bg/faq-bg-pattern.png')); ?>">
    <div class="container">
        <div class="section-title-wrapper text-center section-title-space">
            <span data-aos="fade-up" data-aos-duration="1000" class="section-subtitle"><?php echo e($data['title_small']); ?></span>
            <h2 data-aos="fade-up" data-aos-duration="1500" class="section-title"><?php echo e($data['title_big']); ?></h2>
        </div>
        <div class="row align-items-center gy-50">
            <div class="col-xxl-6 col-xl-6 col-lg-6">
                <div class="faq-thumb" data-aos="fade-right">
                    <?php if(content_exists($data['left_img'])): ?>
                    <img class="thumb-normal" src="<?php echo e(asset($data['left_img'])); ?>" alt="faq thumb bot found">
                    <?php endif; ?>
                    <?php if(content_exists($data['left_img'])): ?>
                    <img class="thumb-dark" src="<?php echo e(asset($data['left_img'])); ?>" alt="faq thumb bot found">
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-xxl-6 col-xl-6 col-lg-6">
                <div class="td-faq style-three">
                    <div class="accordion" id="accordionExample">
                        <?php $__currentLoopData = $landingContent; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $content): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div data-aos="fade-up" data-aos-duration="1000" class="accordion-item">
                            <h2 class="accordion-header" id="heading<?php echo e($content->id); ?>">
                                <button class="accordion-button <?php echo e($loop->iteration != 1 ? 'collapsed' : ''); ?> " type="button" data-bs-toggle="collapse"
                                    data-bs-target="#collapse<?php echo e($content->id); ?>" aria-expanded="<?php echo e($loop->iteration == 1 ? 'true' : 'false'); ?>"
                                    aria-controls="collapse<?php echo e($content->id); ?>">
                                    <?php echo e($content->title); ?>

                                </button>
                            </h2>
                            <div id="collapse<?php echo e($content->id); ?>" class="accordion-collapse <?php if($loop->iteration == 1): ?> collapse show <?php else: ?> collapse  <?php endif; ?>"
                                aria-labelledby="heading<?php echo e($content->id); ?>" data-bs-parent="#accordionExample">
                                <div class="accordion-body">
                                    <p>
                                        <?php echo nl2br(e($content->description)); ?>

                                    </p>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="faq-shapes">
        <div class="shape-two">
            <img data-parallax='{"y" : -120, "smoothness": 20}' src="<?php echo e(asset('/front/images/shapes/faq-02.png')); ?>" alt="faq shape not found">
        </div>
    </div>
</section>
<!-- FAQ area end -->
<?php /**PATH /home/oyxmpnpf/paysmart.azonetech.com.ng/app/Providers/../../resources/views/frontend/default/home/include/__faq.blade.php ENDPATH**/ ?>