
<!-- Plan start  -->
<section class="pricing-area theme-bg-1 section-space">
    <div class="container">
        <div class="row gy-3 align-items-center justify-content-between section-title-space">
            <div class="col-xxl-6 col-xl-6 col-lg-6">
                <div class="section-title-wrapper">
                    <span data-aos="fade-up" data-aos-duration="1000" class="section-subtitle">
                        <?php echo e($data['title_small']); ?>

                    </span>
                    <h2 data-aos="fade-up" data-aos-duration="1500" class="section-title">
                        <?php echo e($data['title_big']); ?>

                    </h2>
                </div>
            </div>
            <div class="col-xxl-6 col-xl-6 col-lg-6">
                <div data-aos="fade-up" data-aos-duration="1500" class="pricing-tab customize-tab ">
                    <ul class="nav nav-tabs" id="myTab" role="tablist">
                        <li class="nav-item" role="presentation">
                            <button class="nav-link active" id="price-tab-one" data-bs-toggle="tab"
                                data-bs-target="#price-tab-one-pane" type="button" role="tab"
                                aria-controls="price-tab-one-pane" aria-selected="true"><span><i
                                        class="fa-regular fa-archive"></i></span><?php echo e(__('DPS')); ?></button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="price-tab-two" data-bs-toggle="tab"
                                data-bs-target="#price-tab-two-pane" type="button" role="tab"
                                aria-controls="price-tab-two-pane" aria-selected="false"><i
                                    class="fa-regular fa-book-blank"></i><?php echo e(__('FDR')); ?></button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="price-tab-three" data-bs-toggle="tab"
                                data-bs-target="#price-tab-three-pane" type="button" role="tab"
                                aria-controls="price-tab-three-pane" aria-selected="false"><span><i
                                        class="fa-regular fa-triangle-exclamation"></i></span><?php echo e(__('Loan')); ?></button>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <?php
            $dps_plans = App\Models\DpsPlan::active()->get();
            $fdr_plans = App\Models\FdrPlan::active()->get();
            $loan_plans = App\Models\LoanPlan::active()->get();
        ?>
        <div class="tab-content" id="myTabContent">
            <div class="tab-pane fade show active" id="price-tab-one-pane" role="tabpanel" aria-labelledby="price-tab-one"
                tabindex="0">
                <div class="row gy-30">
                    <?php $__currentLoopData = $dps_plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-xxl-3 col-xl-3 col-lg-4 col-md-6 col-sm-6">
                        <div class="price-item" data-aos="fade-up" data-aos-duration="6000">
                            <?php if($plan->featured): ?>
                            <span class="price-badge"><?php echo e($plan->badge); ?></span>
                            <?php endif; ?>
                            <div class="price-top">
                                <div class="price-title">
                                    <h4><?php echo e($plan->name); ?></h4>
                                </div>
                                <div class="price-value">
                                    <strong><?php echo e(setting('currency_symbol', 'global')); ?><?php echo e($plan->per_installment); ?></strong>
                                    <sub>/ <?php echo e($plan->interval); ?> <?php echo e(__('Days')); ?></sub>
                                </div>
                            </div>
                            <div class="info-list">
                                <ul>
                                    <li><span><i class="fa-regular fa-check"></i></span><?php echo e(__('Interest Rate')); ?> : <?php echo e($plan->interest_rate); ?>%</li>
                                    <li><span><i class="fa-regular fa-check"></i></span><?php echo e(__('Number of Installments')); ?> : <?php echo e($plan->total_installment); ?></li>
                                    <li><span><i class="fa-regular fa-check"></i></span><?php echo e(__('Per Installment')); ?> : <?php echo e($currencySymbol.$plan->per_installment); ?></li>
                                    <li><span><i class="fa-regular fa-check"></i></span><?php echo e(__('Installment Slice')); ?> : <?php echo e($plan->interval); ?> <?php echo e(__('Days')); ?></li>
                                    <li><span><i class="fa-regular fa-check"></i></span><?php echo e(__('All Deposits')); ?> : <?php echo e($currencySymbol.$plan->total_deposit); ?></li>
                                    <li><span><i class="fa-regular fa-check"></i></span><?php echo e(__('Final Maturity')); ?> : <?php echo e($currencySymbol.$plan->total_mature_amount); ?></li>
                                </ul>
                            </div>
                            <div class="price-btn">
                                <a class="pricing-btn w-100" href="<?php echo e(route('user.dps.index')); ?>"><?php echo e(__('Subscribe')); ?></a>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <div class="tab-pane fade" id="price-tab-two-pane" role="tabpanel" aria-labelledby="price-tab-two"
                tabindex="0">
                <div class="row gy-30">
                    <?php $__currentLoopData = $fdr_plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-xxl-3 col-xl-3 col-lg-4 col-md-6 col-sm-6">
                        <div class="price-item" data-aos="fade-up" data-aos-duration="6000">
                            <?php if($plan->featured): ?>
                            <span class="price-badge"><?php echo e($plan->badge); ?></span>
                            <?php endif; ?>
                            <div class="price-top">
                                <div class="price-title">
                                    <h4><?php echo e($plan->name); ?></h4>
                                </div>
                                <div class="price-value">
                                    <strong><?php echo e($plan->interest_rate); ?>%</strong>
                                    <sub>/ <?php echo e($plan->intervel); ?> <?php echo e(__('Days')); ?></sub>
                                </div>
                            </div>
                            <div class="info-list">
                                <ul>
                                    <li><span><i class="fa-regular fa-check"></i></span><?php echo e(__('Lock In Period')); ?> : <?php echo e($plan->locked); ?> <?php echo e(__('Days')); ?></li>
                                    <li><span><i class="fa-regular fa-check"></i></span><?php echo e(__('Get Profit Every')); ?> : <?php echo e($plan->intervel); ?> <?php echo e(__('Days')); ?></li>
                                    <li><span><i class="fa-regular fa-check"></i></span><?php echo e(__('Profit Rate')); ?> : <?php echo e($plan->interest_rate); ?>%</li>
                                    <li><span><i class="fa-regular fa-check"></i></span><?php echo e(__('Minimum FDR')); ?> : <?php echo e($currencySymbol.$plan->minimum_amount); ?></li>
                                    <li><span><i class="fa-regular fa-check"></i></span><?php echo e(__('Miximum FDR')); ?> : <?php echo e($currencySymbol.$plan->maximum_amount); ?></li>
                                    <li><span><i class="fa-regular fa-check"></i></span><?php echo e(__('Compounding')); ?> : <?php echo e($plan->is_compounding ? "Yes" : 'No'); ?></li>
                                    <li><span><i class="fa-regular fa-check"></i></span><?php echo e(__('Cancel In')); ?> : <?php echo e($plan->cancel_type == 'anytime' ? 'Anytime' : $plan->cancel_days.' Days'); ?></li>
                                </ul>
                            </div>
                            <div class="price-btn">
                                <a class="pricing-btn w-100" href="<?php echo e(route('user.fdr.index')); ?>"><?php echo e(__('Subscribe')); ?></a>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <div class="tab-pane fade" id="price-tab-three-pane" role="tabpanel" aria-labelledby="price-tab-three"
                tabindex="0">
                <div class="row gy-30">
                    <?php $__currentLoopData = $loan_plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-xxl-3 col-xl-3 col-lg-4 col-md-6 col-sm-6">
                        <div class="price-item" data-aos="fade-up" data-aos-duration="6000">
                            <div class="price-top">
                                <div class="price-title">
                                    <h4><?php echo e($plan->name); ?></h4>
                                </div>
                                <div class="price-value">
                                    <strong><?php echo e($plan->per_installment); ?>%</strong>
                                    <sub>/ <?php echo e($plan->installment_intervel); ?> <?php echo e(__('Days')); ?></sub>
                                </div>
                            </div>
                            <div class="info-list">
                                <ul>
                                    <li><span><i class="fa-regular fa-check"></i></span><?php echo e(__('Minimum Loan')); ?> : <?php echo e($currencySymbol.$plan->minimum_amount); ?></li>
                                    <li><span><i class="fa-regular fa-check"></i></span><?php echo e(__('Miximum Loan')); ?> : <?php echo e($currencySymbol.$plan->maximum_amount); ?></li>
                                    <li><span><i class="fa-regular fa-check"></i></span><?php echo e(__('Installment Rate')); ?> : <?php echo e($plan->per_installment); ?>%</li>
                                    <li><span><i class="fa-regular fa-check"></i></span><?php echo e(__('Installment Slice')); ?> : <?php echo e($plan->installment_intervel); ?> <?php echo e(__('Days')); ?></li>
                                    <li><span><i class="fa-regular fa-check"></i></span><?php echo e(__('Total Installment')); ?> : <?php echo e($plan->total_installment); ?></li>
                                </ul>
                            </div>
                            <div class="price-btn">
                                <a class="pricing-btn w-100" href="<?php echo e(route('user.loan.index')); ?>"><?php echo e(__('Apply Now')); ?></a>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Plan end  -->
<?php /**PATH /home/oyxmpnpf/paysmart.azonetech.com.ng/app/Providers/../../resources/views/frontend/default/home/include/__plansection.blade.php ENDPATH**/ ?>