
<?php $__env->startSection('title'); ?>
    <?php echo e(__('Electricity')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-xl-12">
            <div class="site-card">
                <div class="site-card-header">
                    <div class="title"><?php echo e(__('Pay Bill')); ?></div>
                    <div class="card-header-links">
                        <a href="<?php echo e(route('user.pay.bill.history')); ?>" class="card-header-link"><i data-lucide="credit-card"></i><?php echo e(__('My Bill Payments')); ?></a>
                    </div>
                </div>
                <div class="site-card-body">

                    <?php echo $__env->make('frontend::pay_bill.include.bill-menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <div class="step-details-form">
                        <form action="<?php echo e(route('user.pay.bill.store')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="col-xl-6 col-lg-6 col-md-6">
                                    <div class="inputs">
                                        <label for="" class="input-label"><?php echo e(__('Countries')); ?> <span class="required">*</span></label>
                                        <select name="country" class="box-input" id="country">
                                            <option value="" selected disabled><?php echo e(__('Select Country')); ?></option>
                                            <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($country); ?>"><?php echo e($country); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-xl-6 col-lg-6 col-md-6">
                                    <div class="inputs">
                                        <label for="" class="input-label"><?php echo e(__('Services')); ?> <span class="required">*</span></label>
                                        <select name="service_id" class="box-input" id="services">
                                            <option value="" selected disabled><?php echo e(__('Select Service')); ?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-xl-6 col-lg-6 col-md-6" id="labels">
                                    <div class="inputs">
                                        <label for="" class="input-label"><?php echo e(__('Meter Number')); ?> <span class="required">*</span></label>
                                        <div class="input-group">
                                            <input type="text" name="data['Meter Number']" class="form-control" placeholder="<?php echo e(__('Meter Number')); ?>">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-6 col-lg-6 col-md-6">
                                    <div class="inputs">
                                        <label for="" class="input-label"><?php echo e(__('Amount')); ?> <span class="required">*</span></label>
                                        <div class="input-group">
                                            <input type="text" name="amount" class="form-control" placeholder="Amount">
                                            <span class="input-group-text" id="currency"><?php echo e($currency); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <?php echo $__env->make('frontend::pay_bill.include.payment-details', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <div class="col-xl-12 col-lg-12 col-md-12">
                                    <button
                                        <?php if(auth()->user()->passcode !== null && setting('pay_bill_passcode_status')): ?>
                                        type="button"
                                        data-bs-toggle="modal"
                                        data-bs-target="#passcode"
                                        <?php else: ?>
                                        type="submit"
                                        <?php endif; ?>
                                        class="site-btn polis-btn"
                                    >
                                        <i data-lucide="check"></i><?php echo e(__('Submit')); ?>

                                    </button>
                                </div>
                            </div>
                            <?php echo $__env->make('frontend::pay_bill.include.passcode-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php echo $__env->make('frontend::pay_bill.include.bill_script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('frontend::layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/oyxmpnpf/paysmart.azonetech.com.ng/app/Providers/../../resources/views/frontend/default/pay_bill/electricity.blade.php ENDPATH**/ ?>